/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.command;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.command.PathSetCommand;
import org.neogia.addonmanager.registry.Registry;

public class AddDirectoryCommand
extends PathSetCommand {
    private boolean force = false;
    private String nb = "";

    public void setNb(String nb) {
        this.nb = nb;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean useForce() {
        return this.force;
    }

    @Override
    protected Map<String, Object> doExecute(AddOnManager addOnManager, String path) {
        Registry registry = addOnManager.getRegistry();
        File dir = new File(path);
        if (!dir.isDirectory()) {
            throw new AddOnManagerException("This command parameter must be a directory", new Object[0]);
        }
        ArrayList<String> remainingDir = new ArrayList<String>();
        remainingDir.add(path);
        while (remainingDir.size() > 0) {
            String[] childNames;
            File currentDir = new File((String)remainingDir.remove(0));
            for (String child : childNames = currentDir.list()) {
                File childFile = new File(currentDir, child);
                if (childFile.isDirectory()) {
                    remainingDir.add(addOnManager.resolvePathToOfbizHomeRelativePath(childFile.getAbsolutePath()));
                    continue;
                }
                registry.addFile(addOnManager.resolvePathToOfbizHomeRelativePath(childFile.getAbsolutePath()), this.force, this.nb);
            }
        }
        return new HashMap<String, Object>();
    }
}

