/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.cli;

import org.neogia.addonmanager.Command;
import org.neogia.addonmanager.cli.CommandFactory;
import org.neogia.addonmanager.command.DiffCommand;

public class DiffCommandFactory
implements CommandFactory {
    @Override
    public Command getCommand(String[] args) {
        DiffCommand cmd = new DiffCommand();
        if (args.length > 0 && (args[0].equals("-r") || args[0].equals("-R"))) {
            for (int i = 1; i < args.length; ++i) {
                cmd.addPath(args[i]);
                cmd.setRevert(true);
            }
            return cmd;
        }
        if (args[0].equals("-index")) {
            for (int i = 1; i < args.length; ++i) {
                cmd.setIndex(true);
                cmd.addPath(args[i]);
            }
            return cmd;
        }
        if (args[0].equals("-size")) {
            for (int i = 2; i < args.length; ++i) {
                cmd.addPath(args[i]);
                cmd.setNb(args[1]);
            }
            return cmd;
        }
        for (String path : args) {
            cmd.addPath(path);
        }
        return cmd;
    }

    @Override
    public String getCommandKeyword() {
        return "diff";
    }

    @Override
    public String getUsage() {
        return "diff [-r | -R | -index | -size X] <path> [<path> [<path> ...]]";
    }
}

