/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.cli;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.Command;
import org.neogia.addonmanager.cli.AddDirectoryCommandFactory;
import org.neogia.addonmanager.cli.AddFileCommandFactory;
import org.neogia.addonmanager.cli.CommandFactory;
import org.neogia.addonmanager.cli.DiffCommandFactory;
import org.neogia.addonmanager.cli.InitCommandFactory;
import org.neogia.addonmanager.cli.InstallAddOnCommandFactory;
import org.neogia.addonmanager.cli.ListAddOnCommandFactory;
import org.neogia.addonmanager.cli.ListAddonFilesCommandFactory;
import org.neogia.addonmanager.cli.NewAddonCommandFactory;
import org.neogia.addonmanager.cli.RaccourcisCommandFactory;
import org.neogia.addonmanager.cli.RemoveFileCommandFactory;
import org.neogia.addonmanager.cli.RevertCommandFactory;
import org.neogia.addonmanager.cli.SealCommandFactory;
import org.neogia.addonmanager.cli.StatusCommandFactory;
import org.neogia.addonmanager.cli.UninstallAddOnCommandFactory;
import org.neogia.addonmanager.cli.UninstallAllAddOnsCommandFactory;
import org.neogia.addonmanager.cli.UpdateFileCommandFactory;
import org.neogia.addonmanager.cli.VersionCommandFactory;

public class Cli {
    private static final Log logger = LogFactory.getLog("addonmanager.cli");
    private Map<String, CommandFactory> supportedCommands = new LinkedHashMap<String, CommandFactory>();
    private AddOnManager addonManager = new AddOnManager();

    public Cli() {
        this.registerCommand(new AddDirectoryCommandFactory());
        this.registerCommand(new AddFileCommandFactory());
        this.registerCommand(new DiffCommandFactory());
        this.registerCommand(new InitCommandFactory());
        this.registerCommand(new InstallAddOnCommandFactory());
        this.registerCommand(new ListAddOnCommandFactory());
        this.registerCommand(new ListAddonFilesCommandFactory());
        this.registerCommand(new NewAddonCommandFactory());
        this.registerCommand(new RemoveFileCommandFactory());
        this.registerCommand(new RevertCommandFactory());
        this.registerCommand(new SealCommandFactory());
        this.registerCommand(new StatusCommandFactory());
        this.registerCommand(new UninstallAddOnCommandFactory());
        this.registerCommand(new UninstallAllAddOnsCommandFactory());
        this.registerCommand(new VersionCommandFactory());
        this.registerCommand(new UpdateFileCommandFactory());
    }

    public void setLogger(boolean logger) {
        this.addonManager.setLog(logger);
    }

    public void registerCommand(CommandFactory commandFactory) {
        this.supportedCommands.put(commandFactory.getCommandKeyword(), commandFactory);
    }

    public Map<String, Object> executeCommand(String[] args) {
        if (args.length > 0) {
            CommandFactory commandFactory = this.supportedCommands.get(args[0].toLowerCase());
            if (commandFactory != null) {
                String[] commandArgs = new String[args.length - 1];
                System.arraycopy(args, 1, commandArgs, 0, args.length - 1);
                Command command = commandFactory.getCommand(commandArgs);
                if (command != null) {
                    return this.addonManager.executeCommand(command);
                }
                this.displayUsage();
                return null;
            }
            this.displayUsage();
            return null;
        }
        this.displayUsage();
        return null;
    }

    public void displayUsage() {
        logger.info("Usage: java -jar " + AddOnManager.class.getName() + " <loglevel level>  command [command args]");
        logger.info("");
        ArrayList<Level> levels = new ArrayList<Level>();
        levels.add(Level.INFO);
        levels.add(Level.ERROR);
        levels.add(Level.WARN);
        levels.add(Level.DEBUG);
        levels.add(Level.TRACE);
        levels.add(Level.ALL);
        levels.add(Level.FATAL);
        levels.add(Level.OFF);
        String supportedLevels = "Supported levels are : ";
        for (Level level : levels) {
            supportedLevels = supportedLevels + "  " + level.toString();
        }
        logger.info(supportedLevels);
        logger.info("");
        logger.info("Supported Commands :");
        for (Map.Entry entry : this.supportedCommands.entrySet()) {
            logger.info(" - " + ((CommandFactory)entry.getValue()).getUsage());
        }
    }

    public static void main(String[] args) {
        Logger rootLogger = Logger.getRootLogger();
        RaccourcisCommandFactory raccourcis = new RaccourcisCommandFactory();
        if ((args = raccourcis.change(args)).length >= 2) {
            String s = args[0];
            if ("loglevel".equalsIgnoreCase(s)) {
                rootLogger.setLevel(Level.toLevel(args[1], Level.INFO));
                String[] commandArgs = new String[args.length - 2];
                System.arraycopy(args, 2, commandArgs, 0, args.length - 2);
            } else {
                rootLogger.setLevel(Level.toLevel(System.getProperty("log.level"), Level.INFO));
            }
        } else {
            rootLogger.setLevel(Level.toLevel(System.getProperty("log.level"), Level.INFO));
        }
        rootLogger.addAppender(new ConsoleAppender(new PatternLayout("[%p] %m%n")));
        try {
            long beginAt = System.currentTimeMillis();
            Cli cli = new Cli();
            if (args.length >= 2 && args[1].equals("-index")) {
                cli.setLogger(false);
            } else {
                cli.setLogger(true);
            }
            cli.executeCommand(args);
            long endAt = System.currentTimeMillis();
            logger.debug("Time: " + (double)(endAt - beginAt) / 1000.0 + " s");
        }
        catch (AddOnManagerException ex) {
            ex.printStackTrace();
            logger.error(ex.getMessage());
            System.exit(-1);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("An unexpected exception occured in addonmanager: " + ex.getMessage(), ex);
            System.exit(-1);
        }
    }

    public AddOnManager getAddOnManager() {
        return this.addonManager;
    }
}

