/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.addon;

import java.io.File;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.addon.AbstractAddOnArchive;

public class ZipAddOnArchive
extends AbstractAddOnArchive {
    private ZipFile zipFile;

    public ZipAddOnArchive(File file) {
        super(file);
    }

    @Override
    public Set<String> getContents() {
        try {
            if (this.zipFile == null) {
                this.zipFile = new ZipFile(this.getLocation());
            }
            Enumeration<? extends ZipEntry> entries = this.zipFile.entries();
            HashSet<String> contents = new HashSet<String>();
            while (entries.hasMoreElements()) {
                contents.add(entries.nextElement().getName());
            }
            HashSet<String> hashSet = contents;
            return hashSet;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AddOnManagerException("An unexpected exception occured while reading zip archive : %s" + this.zipFile.getName(), ex.getMessage(), ex);
        }
        finally {
            if (this.zipFile != null) {
                try {
                    this.zipFile.close();
                }
                catch (Exception ignoredException) {}
                this.zipFile = null;
            }
        }
    }

    @Override
    public InputStream doReadFile(String path) {
        try {
            if (this.zipFile == null) {
                this.zipFile = new ZipFile(this.getLocation());
            }
            return this.zipFile.getInputStream(this.zipFile.getEntry(path));
        }
        catch (Exception ex) {
            if (this.zipFile != null) {
                try {
                    this.zipFile.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.zipFile = null;
            }
            ex.printStackTrace();
            throw new AddOnManagerException("An unexpected exception occured while reading zip archive : %s" + this.zipFile.getName(), ex.getMessage(), ex);
        }
    }

    @Override
    public void writeFile(String path, InputStream in) {
        throw new UnsupportedOperationException("writeFile operation not yet supported on ZipAddOnArchive");
    }

    @Override
    public void deleteFile(String path) {
        throw new UnsupportedOperationException("deleteFile operation not yet supported on ZipAddOnArchive");
    }
}

