/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.addon;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.addon.AbstractAddOnArchive;
import org.neogia.addonmanager.addon.ZipAddOnArchive;

public class DirectoryAddOnArchive
extends AbstractAddOnArchive {
    private static final Log logger = LogFactory.getLog("addonmanager.addon");

    public DirectoryAddOnArchive(File dir) {
        super(dir);
    }

    @Override
    public Set<String> getContents() {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(this.getLocation());
        int prefixCount = this.getLocation().getAbsolutePath().length() + 1;
        HashSet<String> contents = new HashSet<String>();
        while (!dirs.isEmpty()) {
            for (File file : ((File)dirs.remove(0)).listFiles()) {
                if (file.isDirectory()) {
                    dirs.add(file);
                    continue;
                }
                String path = file.getAbsolutePath().substring(prefixCount);
                contents.add(path);
            }
        }
        return contents;
    }

    @Override
    protected InputStream doReadFile(String path) {
        File file = new File(this.getLocation(), path);
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Reading file '" + file.getAbsolutePath() + "'");
            }
            return new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            return null;
        }
    }

    @Override
    public void writeFile(String path, InputStream in) {
        File destFile = new File(this.getLocation(), path);
        destFile.getParentFile().mkdirs();
        OutputStream out = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Writing file '" + destFile.getAbsolutePath() + "'");
            }
            out = new FileOutputStream(destFile, false);
            byte[] buffer = new byte[4096];
            int read = 0;
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
        }
        catch (Exception ex) {
            destFile.delete();
            throw new AddOnManagerException("An unexpected exception occured while writing file '%s' to add-on archive", path, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignoredException) {}
            }
        }
    }

    @Override
    public void deleteFile(String path) {
        File destFile = new File(this.getLocation(), path);
        if (!destFile.delete()) {
            throw new AddOnManagerException("Unable to delete file '%s' from add-on archive", destFile);
        }
    }

    public ZipAddOnArchive generateZipAddOnArchive(File destFile) {
        ArrayList<File> dirs = new ArrayList<File>();
        dirs.add(this.getLocation());
        int prefixCount = this.getLocation().getAbsolutePath().length() + 1;
        ZipOutputStream zout = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Writing file '" + destFile.getAbsolutePath() + "'");
            }
            zout = new ZipOutputStream(new FileOutputStream(destFile, false));
            while (!dirs.isEmpty()) {
                if (".svn".equals(((File)dirs.get(0)).getName()) || "CVS".equals(((File)dirs.get(0)).getName())) {
                    dirs.remove(0);
                    continue;
                }
                for (File file : ((File)dirs.remove(0)).listFiles()) {
                    if (file.isDirectory()) {
                        dirs.add(file);
                        continue;
                    }
                    String path = file.getAbsolutePath().substring(prefixCount);
                    ZipEntry entry = new ZipEntry(path);
                    entry.setTime(file.lastModified());
                    FileInputStream in = null;
                    try {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Reading file '" + file.getAbsolutePath() + "'");
                        }
                        if (logger.isDebugEnabled()) {
                            logger.debug("Writing zip entry '" + entry.getName() + "'");
                        }
                        zout.putNextEntry(entry);
                        in = new FileInputStream(file);
                        byte[] buffer = new byte[4096];
                        int read = 0;
                        while ((read = in.read(buffer)) != -1) {
                            zout.write(buffer, 0, read);
                        }
                    }
                    catch (Exception ex) {
                        throw new AddOnManagerException("Fail to write zip entry '%s' to file '%s'", path, destFile.getAbsolutePath(), ex);
                    }
                    finally {
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception ignoredException) {}
                        }
                    }
                }
            }
            File[] arr$ = new ZipAddOnArchive(destFile);
            return arr$;
        }
        catch (AddOnManagerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new AddOnManagerException("Fail to create zip archive '%s' from '%s'", destFile.getAbsolutePath(), this.getLocation());
        }
        finally {
            if (zout != null) {
                try {
                    zout.close();
                }
                catch (Exception ignoredException) {}
            }
        }
    }
}

