/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.addon;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.util.UtilXml;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AddOnDescriptor {
    private final String INDENTATION = "  ";
    private Document doc;
    private Element addOnElement;
    private Element artifactIdElement;
    private Element nameElement;
    private Element versionElement;

    public AddOnDescriptor(InputStream in) {
        try {
            this.doc = UtilXml.readXmlDocument(in, true, null);
            this.addOnElement = this.doc.getDocumentElement();
            NodeList list = this.addOnElement.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (list.item(i).getNodeName() == "artifactId") {
                    this.artifactIdElement = (Element)list.item(i);
                }
                if (list.item(i).getNodeName() == "name") {
                    this.nameElement = (Element)list.item(i);
                }
                if (list.item(i).getNodeName() != "version") continue;
                this.versionElement = (Element)list.item(i);
            }
        }
        catch (Exception ex) {
            throw new AddOnManagerException("An unexpected exception occured while reading add-on descriptor", new Object[]{ex});
        }
    }

    public AddOnDescriptor(String name) {
        this.doc = UtilXml.makeEmptyXmlDocument("add-on");
        this.addOnElement = this.doc.getDocumentElement();
        this.artifactIdElement = this.doc.createElement("artifactId");
        this.artifactIdElement.setTextContent(name);
        this.doc.getDocumentElement().appendChild(this.artifactIdElement);
    }

    public String getArtifactId() {
        return this.artifactIdElement.getTextContent();
    }

    public String getName() {
        return this.nameElement == null ? "" : this.nameElement.getTextContent();
    }

    public String getVersion() {
        if (this.versionElement == null) {
            return null;
        }
        return this.versionElement.getTextContent();
    }

    public void setVersion(String version) {
        if (this.versionElement == null) {
            this.versionElement = this.doc.createElement("version");
            this.doc.getDocumentElement().appendChild(this.versionElement);
        }
        this.versionElement.setTextContent(version);
    }

    public String getDescription() {
        return this.getMultiLineTextElement(this.addOnElement, "description");
    }

    public void setDescription(String description) {
        this.setMultiLineTextElement(this.addOnElement, "description", description, "  ");
    }

    public void save(OutputStream out) throws IOException {
        UtilXml.writeXmlDocument(out, (Node)this.doc);
    }

    private String getMultiLineTextElement(Element parentElement, String elementName) {
        String text = null;
        NodeList elements = parentElement.getElementsByTagName(elementName);
        if (elements.getLength() > 0) {
            Element element = (Element)elements.item(0);
            text = element.getTextContent().replaceAll("^\\s*\n\\s*", "").replaceAll("\n\\s+", "\n").replaceAll("\n\\s*$", "");
        }
        return text;
    }

    private Element setMultiLineTextElement(Element parentElement, String elementName, String text, String indentation) {
        NodeList elements = parentElement.getElementsByTagName(elementName);
        Element element = null;
        if (text == null) {
            if (elements.getLength() > 0) {
                element = (Element)elements.item(0);
                element.getParentNode().removeChild(element);
                element = null;
            }
        } else {
            if (elements.getLength() <= 0) {
                element = this.doc.createElement(elementName);
                parentElement.appendChild(element);
            }
            element = (Element)elements.item(0);
            int identationLevel = 1;
            while (parentElement != null && parentElement != this.doc.getDocumentElement()) {
                parentElement = (Element)parentElement.getParentNode();
                ++identationLevel;
            }
            String[] lines = text.split("\n");
            if (lines.length > 1) {
                StringBuilder builder = new StringBuilder("\n");
                for (String line : lines) {
                    for (int i = 0; i < identationLevel; ++i) {
                        builder.append(indentation);
                    }
                    builder.append(line).append("\n");
                }
                for (int i = 0; i < identationLevel - 1; ++i) {
                    builder.append(indentation);
                }
                text = builder.toString();
            }
            element.setTextContent(text);
        }
        return element;
    }
}

