/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.addon;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UIKeyboardInteractive;
import com.jcraft.jsch.UserInfo;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.CommitEventHandler;
import org.neogia.addonmanager.addon.AddOnArchive;
import org.neogia.addonmanager.addon.AddOnDescriptor;
import org.neogia.addonmanager.addon.AddOnInterface;
import org.neogia.addonmanager.addon.DirectoryAddOnArchive;
import org.neogia.addonmanager.addon.ZipAddOnArchive;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.registry.Registry;
import org.tmatesoft.svn.core.SVNDepth;
import org.tmatesoft.svn.core.SVNDirEntry;
import org.tmatesoft.svn.core.SVNURL;
import org.tmatesoft.svn.core.auth.BasicAuthenticationManager;
import org.tmatesoft.svn.core.auth.SVNAuthentication;
import org.tmatesoft.svn.core.auth.SVNSSHAuthentication;
import org.tmatesoft.svn.core.internal.io.svn.SVNRepositoryFactoryImpl;
import org.tmatesoft.svn.core.internal.wc.DefaultSVNOptions;
import org.tmatesoft.svn.core.io.SVNRepository;
import org.tmatesoft.svn.core.io.SVNRepositoryFactory;
import org.tmatesoft.svn.core.wc.ISVNOptions;
import org.tmatesoft.svn.core.wc.SVNClientManager;
import org.tmatesoft.svn.core.wc.SVNRevision;
import org.tmatesoft.svn.core.wc.SVNWCUtil;

public class AddOn
implements AddOnInterface {
    private static final Log logger = LogFactory.getLog("addonmanager.addon");
    private static final String ADDON_DESCRIPTOR_FILENAME = "add-on.xml";
    private static final String DEFAULT_VERSION = "SNAPSHOT";
    private AddOnArchive archive;
    private AddOnDescriptor addOnDescriptor;
    private boolean sealed = true;

    public AddOn(File location) {
        if (location.isDirectory()) {
            this.archive = new DirectoryAddOnArchive(location);
            this.sealed = false;
        } else if (location.isFile()) {
            this.archive = new ZipAddOnArchive(location);
        } else {
            throw new AddOnManagerException("Invalid add-on location '%s'", location);
        }
        this.addOnDescriptor = new AddOnDescriptor(this.archive.readFile(ADDON_DESCRIPTOR_FILENAME));
    }

    @Override
    public File getLocation() {
        return this.archive.getLocation();
    }

    @Override
    public String getArtifactId() {
        return this.addOnDescriptor.getArtifactId();
    }

    @Override
    public String getName() {
        return this.addOnDescriptor.getName();
    }

    @Override
    public String getDescription() {
        return this.addOnDescriptor.getDescription();
    }

    @Override
    public String getVersion() {
        return this.addOnDescriptor.getVersion();
    }

    @Override
    public boolean isSealed() {
        return this.sealed;
    }

    @Override
    public AddOnArchive getArchive() {
        return this.archive;
    }

    @Override
    public File seal(String finalVersion, String passephrase, String commitMsg, Registry registry, boolean httpPublish, boolean svnPublish) {
        if (this.isSealed()) {
            throw new AddOnManagerException("Add-on '%s' is already sealed", this.getArtifactId());
        }
        File destDir = this.getLocation().getParentFile();
        File destFile = new File(destDir, this.getArtifactId() + "-" + finalVersion + ".zip");
        if (destFile.exists()) {
            try {
                destFile.renameTo(new File(destFile.getCanonicalPath().concat("" + System.currentTimeMillis())));
            }
            catch (Exception e) {
                throw new AddOnManagerException("Found '%s' sealed version of add-on '%s' Rename Operation Failed", finalVersion, this.getArtifactId());
            }
        }
        this.addOnDescriptor.setVersion(finalVersion);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            this.addOnDescriptor.save(out);
        }
        catch (Exception ex) {
            throw new AddOnManagerException("Fail to update add-on descriptor", new Object[]{ex});
        }
        ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
        this.archive.writeFile(ADDON_DESCRIPTOR_FILENAME, in);
        try {
            in.close();
        }
        catch (Exception e) {
            // empty catch block
        }
        registry.updateAddonIvyFile(this, finalVersion);
        if (svnPublish) {
            this.publishToSvn(registry, passephrase, commitMsg);
        }
        this.archive = ((DirectoryAddOnArchive)this.archive).generateZipAddOnArchive(destFile);
        if (httpPublish) {
            this.publishToHttp(registry, passephrase, finalVersion);
        }
        this.sealed = true;
        return this.archive.getLocation();
    }

    @Override
    public Set<String> getPathsToPatch() {
        return this.archive.getPathsWithPatch();
    }

    @Override
    public List<Patch> getPatchs(String path) {
        return this.archive.getPatchs(path);
    }

    public static AddOn newAddOnFromScratch(File dir, String name) {
        if (name == null || name.length() == 0) {
            throw new AddOnManagerException("Unable to create an add-on with a null or empty name", new Object[0]);
        }
        if (dir.exists()) {
            throw new AddOnManagerException("Unable to create add-on '%s' due to existing location '%s'", name, dir.getAbsolutePath());
        }
        if (!dir.mkdir()) {
            throw new AddOnManagerException("Unable to create directory '%s' for add-on '%s'", dir.getAbsolutePath(), name);
        }
        File descriptorFile = new File(dir, ADDON_DESCRIPTOR_FILENAME);
        FileOutputStream out = null;
        try {
            AddOnDescriptor descriptor = new AddOnDescriptor(name);
            descriptor.setVersion(DEFAULT_VERSION);
            if (logger.isDebugEnabled()) {
                logger.debug("Writing file '" + descriptorFile.getAbsolutePath() + "'");
            }
            out = new FileOutputStream(descriptorFile);
            descriptor.save(out);
        }
        catch (Exception ex) {
            descriptorFile.delete();
            dir.delete();
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignoredException) {
                    // empty catch block
                }
            }
            if (ex instanceof AddOnManagerException) {
                throw (AddOnManagerException)ex;
            }
            throw new AddOnManagerException("An unexpected exception occured while write descriptor '%s'", descriptorFile.getAbsolutePath(), ex);
        }
        return new AddOn(dir);
    }

    private void publishToSvn(Registry registry, String passephrase, String commitMsg) {
        File addonDirTemp = this.getLocation();
        try {
            String locca = addonDirTemp.getCanonicalPath();
            File addonDir = new File(locca);
            SVNRepositoryFactoryImpl.setup();
            SVNRepository repository = null;
            String svnHost = registry.getSvnRepositoryUrl();
            String svnUser = registry.getSvnRepositoryUser();
            String svnPortStr = registry.getSvnRepositoryPort();
            int svnPort = 22;
            try {
                svnPort = Integer.valueOf(svnPortStr);
            }
            catch (Exception e) {
                svnPort = 22;
            }
            File svnPKFile = new File(registry.getSvnRepositoryPKPath());
            String svnPassword = passephrase;
            DefaultSVNOptions options = SVNWCUtil.createDefaultOptions(true);
            ArrayList<SVNSSHAuthentication> authentications = new ArrayList<SVNSSHAuthentication>();
            SVNSSHAuthentication svnSSHAuthentication = new SVNSSHAuthentication(svnUser, svnPKFile, svnPassword, svnPort, true);
            authentications.add(svnSSHAuthentication);
            BasicAuthenticationManager authManager = new BasicAuthenticationManager(authentications.toArray(new SVNAuthentication[0]));
            CommitEventHandler commitEventHandler = new CommitEventHandler();
            SVNURL url = null;
            SVNURL importUrl = null;
            boolean exists = false;
            url = SVNURL.parseURIEncoded(svnHost);
            importUrl = url.appendPath("/" + addonDir.getName(), false);
            repository = SVNRepositoryFactory.create(SVNURL.parseURIEncoded(svnHost));
            repository.setAuthenticationManager(authManager);
            Collection entries = repository.getDir("", -1L, null, (Collection)null);
            for (SVNDirEntry entry : entries) {
                if (!addonDir.getName().equals(entry.getName())) continue;
                exists = true;
                break;
            }
            SVNClientManager clientMgr = SVNClientManager.newInstance((ISVNOptions)options, authManager);
            if (!exists) {
                clientMgr.getCommitClient().setEventHandler(commitEventHandler);
                clientMgr.getCommitClient().doImport(addonDir, importUrl, commitMsg, null, true, false, SVNDepth.INFINITY);
            } else {
                File wCLoc = this.getLocation();
                for (File tempFile : wCLoc.listFiles()) {
                    if (".svn".equals(tempFile.getName())) continue;
                    clientMgr.getWCClient().doAdd(tempFile, true, false, true, SVNDepth.INFINITY, true, true);
                }
                clientMgr.getCommitClient().doCommit(new File[]{wCLoc}, true, commitMsg, null, null, false, false, SVNDepth.INFINITY);
            }
            clientMgr.getUpdateClient().doUpdate(new File[]{this.getLocation()}, SVNRevision.HEAD, SVNDepth.fromRecurse(true), false, false);
        }
        catch (Exception e) {
            throw new AddOnManagerException(e.toString(), new Object[]{e});
        }
    }

    public void publishToHttp(Registry registry, String passephrase, String revision) {
        String host = registry.getHttpRepositoryUrl();
        String repoDir = registry.getHttpRepositoryDir();
        if (repoDir == null || "".equals(repoDir)) {
            repoDir = "/var/www/addons.neogia.org/addons/";
        }
        if (!repoDir.endsWith("/")) {
            repoDir = repoDir.concat("/");
        }
        String user = registry.getHttpRepositoryUser();
        String portStr = registry.getHttpRepositoryPort();
        int port = 22;
        try {
            port = Integer.valueOf(portStr);
        }
        catch (Exception e) {
            port = 22;
        }
        File pKFile = new File(registry.getHttpRepositoryPKPath());
        try {
            File localTemp = File.createTempFile("willBeDeleted", "");
            if (!localTemp.delete()) {
                throw new AddOnManagerException("Exception :  while creating temp dir when publishing the addon " + this.getArtifactId(), new Object[0]);
            }
            localTemp.deleteOnExit();
            if (!localTemp.mkdir()) {
                throw new AddOnManagerException("Exception :  while creating temp dir when publishing the addon " + this.getArtifactId(), new Object[0]);
            }
            File tempAddonDir = new File(localTemp, this.getArtifactId());
            if (!tempAddonDir.isDirectory() && !tempAddonDir.mkdir()) {
                throw new AddOnManagerException("Exception :  while creating temp dir when publishing the addon " + this.getArtifactId(), new Object[0]);
            }
            tempAddonDir.deleteOnExit();
            File revisionDir = new File(tempAddonDir, revision);
            if (!revisionDir.isDirectory() && !revisionDir.mkdir()) {
                throw new AddOnManagerException("Exception :  while creating temp dir when publishing the addon " + this.getArtifactId(), new Object[0]);
            }
            String localFile = this.getArchive().getLocation().getCanonicalPath();
            this.copyDirectory(new File(localFile), revisionDir);
            File ivyFile = registry.getIvyFile(this.getArchive().getLocation());
            if (ivyFile != null) {
                File namedIvyFile = new File(ivyFile.getParent(), "ivy.xml");
                ivyFile.renameTo(namedIvyFile);
                this.copyDirectory(namedIvyFile, revisionDir);
            }
            String remoteTargetDirectory = repoDir;
            JSch jsch = new JSch();
            jsch.addIdentity(pKFile.getCanonicalPath());
            File knownFile = new File(pKFile.getParent(), "known_hosts");
            jsch.setKnownHosts(knownFile.getCanonicalPath());
            Session session = jsch.getSession(user, host, port);
            MyUserInfo ui = new MyUserInfo(passephrase);
            session.setUserInfo(ui);
            session.connect();
            boolean first = true;
            ArrayList<File> listFiles = new ArrayList<File>();
            listFiles.add(tempAddonDir);
            while (listFiles.size() > 0) {
                int len;
                String command;
                File toCopy = (File)listFiles.remove(0);
                if (toCopy.isDirectory()) {
                    Channel mkDirChannel = session.openChannel("exec");
                    if (first) {
                        remoteTargetDirectory = remoteTargetDirectory + this.getArtifactId() + "/";
                        first = false;
                    } else {
                        remoteTargetDirectory = remoteTargetDirectory + toCopy.getName() + "/";
                    }
                    listFiles.addAll(this.getSubFIles(toCopy));
                    command = "mkdir " + remoteTargetDirectory;
                    mkDirChannel.setInputStream(null);
                    ((ChannelExec)mkDirChannel).setCommand(command);
                    ((ChannelExec)mkDirChannel).setErrStream(System.out);
                    InputStream in = mkDirChannel.getInputStream();
                    mkDirChannel.connect();
                    this.verifyResponse(in, mkDirChannel);
                    mkDirChannel.disconnect();
                    continue;
                }
                Channel channel = session.openChannel("exec");
                command = "scp -p -r -t " + remoteTargetDirectory;
                ((ChannelExec)channel).setCommand(command);
                OutputStream out = channel.getOutputStream();
                InputStream in = channel.getInputStream();
                channel.connect();
                AddOn.checkAck(in);
                FileInputStream fis = null;
                String lfile = toCopy.getCanonicalPath();
                long filesize = new File(lfile).length();
                command = "C0644 " + filesize + " ";
                command = lfile.lastIndexOf(47) > 0 ? command + lfile.substring(lfile.lastIndexOf(47) + 1) : command + lfile;
                command = command + "\n";
                out.write(command.getBytes());
                out.flush();
                AddOn.checkAck(in);
                fis = new FileInputStream(lfile);
                byte[] buf = new byte[1024];
                while ((len = fis.read(buf, 0, buf.length)) > 0) {
                    out.write(buf, 0, len);
                }
                fis.close();
                fis = null;
                buf[0] = 0;
                out.write(buf, 0, 1);
                out.flush();
                AddOn.checkAck(in);
                out.close();
                toCopy = null;
                channel.disconnect();
            }
            Channel execHashAddon = session.openChannel("exec");
            String command = "sh hashThisAddon.sh";
            execHashAddon.setInputStream(null);
            ((ChannelExec)execHashAddon).setCommand(command);
            ((ChannelExec)execHashAddon).setErrStream(System.out);
            InputStream in = execHashAddon.getInputStream();
            execHashAddon.connect();
            this.verifyResponse(in, execHashAddon);
            execHashAddon.disconnect();
            session.disconnect();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw new AddOnManagerException("Verify that you have permission while executing publishing the addon " + this.getArtifactId(), new Object[0]);
        }
    }

    public List<File> getSubFIles(File parent) {
        ArrayList<File> result = new ArrayList<File>();
        for (File child : parent.listFiles()) {
            result.add(child);
        }
        return result;
    }

    public void copyDirectory(File sourceLocation, File targetLocation) throws IOException {
        if (sourceLocation.isDirectory()) {
            if (".svn".equals(sourceLocation.getName())) {
                return;
            }
            if (!targetLocation.exists()) {
                targetLocation.mkdir();
            }
            String[] children = sourceLocation.list();
            for (int i = 0; i < children.length; ++i) {
                this.copyDirectory(new File(sourceLocation, children[i]), new File(targetLocation, children[i]));
            }
        } else if (targetLocation.isDirectory()) {
            this.copyDirectory(sourceLocation, new File(targetLocation, sourceLocation.getName()));
        } else {
            int len;
            FileInputStream in = new FileInputStream(sourceLocation);
            FileOutputStream out = new FileOutputStream(targetLocation);
            byte[] buf = new byte[1024];
            while ((len = ((InputStream)in).read(buf)) > 0) {
                ((OutputStream)out).write(buf, 0, len);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }

    static int checkAck(InputStream in) throws IOException {
        int b = in.read();
        if (b == 0) {
            return b;
        }
        if (b == -1) {
            return b;
        }
        if (b == 1 || b == 2 || b == -1) {
            int c;
            StringBuffer sb = new StringBuffer();
            do {
                c = in.read();
                sb.append((char)c);
            } while (c != 10);
            throw new AddOnManagerException(sb.toString(), new Object[0]);
        }
        return b;
    }

    void verifyResponse(InputStream in, Channel channel) throws IOException {
        byte[] tmp = new byte[1024];
        while (true) {
            int i;
            if (in.available() > 0 && (i = in.read(tmp, 0, 1024)) >= 0) {
                System.out.print(new String(tmp, 0, i));
                continue;
            }
            if (channel.isClosed()) break;
            try {
                Thread.sleep(1000L);
            }
            catch (Exception ee) {}
        }
        System.out.println("exit-status: " + channel.getExitStatus());
    }

    public static class MyUserInfo
    implements UserInfo,
    UIKeyboardInteractive {
        String passphrase;

        public MyUserInfo(String passphrase) {
            this.passphrase = passphrase;
        }

        @Override
        public String getPassword() {
            return this.passphrase;
        }

        @Override
        public boolean promptYesNo(String str) {
            return true;
        }

        @Override
        public String getPassphrase() {
            return this.passphrase;
        }

        @Override
        public boolean promptPassphrase(String message) {
            return true;
        }

        @Override
        public boolean promptPassword(String message) {
            return true;
        }

        @Override
        public void showMessage(String message) {
        }

        @Override
        public String[] promptKeyboardInteractive(String destination, String name, String instruction, String[] prompt, boolean[] echo) {
            String[] ret = new String[]{this.passphrase};
            return ret;
        }
    }
}

