/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager.addon;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.addon.AddOnArchive;
import org.neogia.addonmanager.patch.Patch;
import org.neogia.addonmanager.patch.PatchService;

public abstract class AbstractAddOnArchive
implements AddOnArchive {
    private static final Pattern PATCH_FILE_PATTERN = Pattern.compile("(.*)\\.(\\d+)\\.([^.]+)\\.patch$");
    private File location;
    private TreeMap<String, TreeMap<Integer, String>> patchIndex;

    public AbstractAddOnArchive(File location) {
        this.location = location;
    }

    @Override
    public File getLocation() {
        return this.location;
    }

    @Override
    public InputStream readFile(String path) {
        InputStream in = this.doReadFile(path);
        if (in == null) {
            throw new AddOnManagerException("Unable to read file '%s' from add-on archive : file does not exist", path);
        }
        return in;
    }

    protected abstract InputStream doReadFile(String var1);

    private void buildPatchIndex() {
        this.patchIndex = new TreeMap();
        for (String fullpath : this.getContents()) {
            Matcher m = PATCH_FILE_PATTERN.matcher(fullpath);
            if (!m.matches()) continue;
            String path = m.group(1);
            int patchOrder = Integer.parseInt(m.group(2));
            TreeMap<Integer, String> patchFiles = this.patchIndex.get(path);
            if (patchFiles == null) {
                patchFiles = new TreeMap();
                this.patchIndex.put(path, patchFiles);
            }
            patchFiles.put(patchOrder, fullpath);
        }
    }

    private Set<String> getPatchFiles(String path) {
        TreeMap<Integer, String> patchFiles;
        LinkedHashSet<String> patchFileSet = new LinkedHashSet<String>();
        if (this.patchIndex == null) {
            this.buildPatchIndex();
        }
        if ((patchFiles = this.patchIndex.get(path)) != null) {
            for (String patchFile : patchFiles.values()) {
                patchFileSet.add(patchFile);
            }
        }
        return patchFileSet;
    }

    @Override
    public boolean existPatch(String testPath) {
        for (String path : this.getContents()) {
            if (!path.startsWith(testPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Set<String> getPathsWithPatch() {
        if (this.patchIndex == null) {
            this.buildPatchIndex();
        }
        return new LinkedHashSet<String>(this.patchIndex.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Patch> getPatchs(String path) {
        if (this.patchIndex == null) {
            this.buildPatchIndex();
        }
        ArrayList<Patch> patchs = new ArrayList<Patch>();
        PatchService patchService = new PatchService(true);
        TreeMap<Integer, String> patchFiles = this.patchIndex.get(path);
        if (patchFiles != null) {
            for (String patchFile : patchFiles.values()) {
                Matcher m = PATCH_FILE_PATTERN.matcher(patchFile);
                if (!m.matches()) continue;
                String patchType = m.group(3);
                InputStream in = null;
                try {
                    in = this.readFile(patchFile);
                    patchs.add(patchService.parsePatch(patchType, in));
                }
                finally {
                    if (in == null) continue;
                    try {
                        in.close();
                    }
                    catch (Exception ignoredException) {}
                }
            }
        }
        return patchs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updatePatchs(String path, List<Patch> patchSet, boolean keepLastPatch) {
        try {
            int i = 0;
            if (!keepLastPatch) {
                this.removePatchs(path);
            } else {
                List<Patch> l = this.getPatchs(path);
                patchSet.addAll(l);
            }
            for (Patch patch : patchSet) {
                Formatter patchFileName = new Formatter();
                patchFileName.format("%s.%d.%s.patch", path, i, patch.getPatchTypeId());
                this.writeFile(patchFileName.toString(), patch.getPatchStream());
                ++i;
            }
        }
        finally {
            this.patchIndex = null;
        }
    }

    @Override
    public void updatePatchs(String path, List<Patch> patchSet) {
        this.updatePatchs(path, patchSet, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePatchs(String path) {
        try {
            for (String existingPatchFile : this.getPatchFiles(path)) {
                this.deleteFile(existingPatchFile);
            }
        }
        finally {
            this.patchIndex = null;
        }
    }
}

