/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager;

import java.io.File;
import org.neogia.addonmanager.Repository;
import org.neogia.addonmanager.Tree;

public class TreeItem
implements Comparable<TreeItem> {
    private Tree parentTree;
    private final String path;
    private String hash;
    private long lastModifiedDate;

    public TreeItem(Tree parentTree, String path, long lastModifiedDate) {
        this(parentTree, path, null, lastModifiedDate);
    }

    public TreeItem(Tree parentTree, String path, String hash, long lastModifiedDate) {
        this.parentTree = parentTree;
        this.path = path;
        this.hash = hash;
        this.lastModifiedDate = lastModifiedDate;
    }

    public String getPath() {
        return this.path;
    }

    public String getHash() {
        return this.hash;
    }

    void setHash(String hash) {
        this.hash = hash;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public String computeHash() {
        return Repository.computeHash(this.getFile());
    }

    public boolean hasChanged() {
        if (this.hash == null) {
            return true;
        }
        return !this.hash.equals(this.computeHash());
    }

    public File getFile() {
        return new File(this.parentTree.getRootDirectory(), this.path);
    }

    public File getRepositoryFile() {
        return this.parentTree.getRepository().writeObjectToTemporaryFile(this.hash);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TreeItem)) {
            return false;
        }
        return this.path.equals(((TreeItem)obj).path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    @Override
    public int compareTo(TreeItem o) {
        return this.path.compareTo(o.path);
    }
}

