/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager;

import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.TreeSet;
import org.neogia.addonmanager.Tree;
import org.neogia.addonmanager.TreeItem;

public class TreeComparator {
    private final Tree oldTree;
    private final Tree newTree;
    private Set<TreeItem> removedTreeItems = new TreeSet<TreeItem>();
    private Set<TreeItem> addedTreeItems = new TreeSet<TreeItem>();
    private Set<TreeItem> modifiedTreeItems = new TreeSet<TreeItem>();

    public TreeComparator(Tree oldTree, Tree newTree) {
        this.oldTree = oldTree;
        this.newTree = newTree;
    }

    public void compare() {
        Set<TreeItem> oldTreeItems = this.oldTree.getItems();
        Set<TreeItem> newTreeItems = this.newTree.getItems();
        HashMap<TreeItem, TreeItem> treeItemsToCompare = new HashMap<TreeItem, TreeItem>();
        for (TreeItem oldTreeItem : oldTreeItems) {
            if (!newTreeItems.contains(oldTreeItem)) {
                this.removedTreeItems.add(oldTreeItem);
                continue;
            }
            treeItemsToCompare.put(oldTreeItem, oldTreeItem);
        }
        for (TreeItem newTreeItem : newTreeItems) {
            if (!oldTreeItems.contains(newTreeItem)) {
                this.addedTreeItems.add(newTreeItem);
                continue;
            }
            TreeItem oldTreeItem = (TreeItem)treeItemsToCompare.get(newTreeItem);
            if (oldTreeItem.getHash().equals(newTreeItem.getHash())) continue;
            this.modifiedTreeItems.add(newTreeItem);
        }
    }

    public Set<TreeItem> getRemovedTreeItems() {
        return Collections.unmodifiableSet(this.removedTreeItems);
    }

    public Set<TreeItem> getAddedTreeItems() {
        return Collections.unmodifiableSet(this.addedTreeItems);
    }

    public Set<TreeItem> getModifiedTreeItems() {
        return Collections.unmodifiableSet(this.modifiedTreeItems);
    }

    public Set<String> getImpactedPathSet() {
        TreeSet<String> pathSet = new TreeSet<String>();
        for (TreeItem treeItem : this.removedTreeItems) {
            pathSet.add(treeItem.getPath());
        }
        for (TreeItem treeItem : this.addedTreeItems) {
            pathSet.add(treeItem.getPath());
        }
        for (TreeItem treeItem : this.modifiedTreeItems) {
            pathSet.add(treeItem.getPath());
        }
        return pathSet;
    }
}

