/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager;

import java.io.File;
import java.io.FileFilter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.neogia.addonmanager.Repository;
import org.neogia.addonmanager.TreeItem;

public class Tree {
    private final Repository repository;
    private final File baseLocation;
    private final Map<String, TreeItem> items = new TreeMap<String, TreeItem>();

    public Tree(Repository repository, File baseLocation) {
        this.repository = repository;
        if (baseLocation == null || !baseLocation.isDirectory()) {
            throw new IllegalArgumentException("Invalid argument baseLocation : baseLocation is null or is not an existing directory");
        }
        this.baseLocation = baseLocation;
    }

    public File getRootDirectory() {
        return this.baseLocation;
    }

    Repository getRepository() {
        return this.repository;
    }

    public TreeItem getTreeItem(String filename) {
        return this.items.get(filename);
    }

    public Set<TreeItem> getItems() {
        return Collections.unmodifiableSet(new TreeSet<TreeItem>(this.items.values()));
    }

    void addItem(String filename, String hash, long lastModifiedDate) {
        this.items.put(filename, new TreeItem(this, filename, hash, lastModifiedDate));
    }

    public void removeItem(String filename) {
        this.items.remove(filename);
    }

    public void addOrUpdateItem(String path, boolean computeHash) {
        TreeItem item = this.items.get(path);
        if (item == null) {
            File file = new File(this.baseLocation, path);
            if (file.isFile()) {
                item = new TreeItem(this, path, file.lastModified());
                if (computeHash) {
                    item.setHash(item.computeHash());
                }
                this.items.put(item.getPath(), item);
            }
        } else {
            File file = item.getFile();
            if (file.isFile()) {
                item.setLastModifiedDate(file.lastModified());
                if (computeHash) {
                    item.setHash(item.computeHash());
                }
            } else {
                this.items.remove(path);
            }
        }
    }

    public void addOrUpdateItem(TreeItem itemSrc) {
        TreeItem itemDst = new TreeItem(this, itemSrc.getPath(), itemSrc.getHash(), itemSrc.getLastModifiedDate());
        this.items.put(itemDst.getPath(), itemDst);
    }

    public void load(final Set<Pattern> excludePatterns) {
        this.items.clear();
        final int prefixLength = this.baseLocation.getAbsolutePath().length() + 1;
        FileFilter defaultFilter = new FileFilter(){

            @Override
            public boolean accept(File child) {
                String path = child.getAbsolutePath().substring(prefixLength).replaceAll("\\\\", "/");
                boolean accept = true;
                for (Pattern p : excludePatterns) {
                    if (!p.matcher(path).matches()) continue;
                    accept = false;
                    break;
                }
                return accept;
            }
        };
        int visited = 0;
        LinkedList<File> remainingDirsToVisit = new LinkedList<File>();
        remainingDirsToVisit.add(this.baseLocation);
        while (!remainingDirsToVisit.isEmpty()) {
            File dirToVisit = (File)remainingDirsToVisit.poll();
            File[] fileArray = dirToVisit.listFiles(defaultFilter);
            int n = fileArray.length;
            int n2 = 0;
            while (n2 < n) {
                File child = fileArray[n2];
                ++visited;
                if (child.isDirectory()) {
                    remainingDirsToVisit.add(child);
                } else {
                    String path = child.getAbsolutePath().substring(prefixLength).replaceAll("\\\\", "/");
                    this.items.put(path, new TreeItem(this, path, child.lastModified()));
                }
                ++n2;
            }
        }
    }

    public void computeHash() {
        ExecutorService executor = Executors.newFixedThreadPool(3);
        final AtomicInteger done = new AtomicInteger();
        for (final TreeItem item : this.items.values()) {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        item.setHash(item.computeHash());
                        done.incrementAndGet();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            });
        }
        executor.shutdown();
        try {
            while (!executor.awaitTermination(500L, TimeUnit.MILLISECONDS)) {
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public Object clone() {
        Tree clonedTree = new Tree(this.repository, this.baseLocation);
        for (TreeItem item : this.items.values()) {
            TreeItem clonedItem = new TreeItem(this, item.getPath(), item.getHash(), item.getLastModifiedDate());
            clonedTree.items.put(clonedItem.getPath(), clonedItem);
        }
        return clonedTree;
    }
}

