/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.InflaterInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.Tree;
import org.neogia.addonmanager.TreeItem;

public class Repository {
    private static final Log logger = LogFactory.getLog("addonmanager.repository");
    private static final String REPOSITORY_DIR = ".addons";
    private static final String DATABASE_DIR = ".db";
    private static final Pattern HASH_PATTERN = Pattern.compile("^[0-9a-f]{40}$");
    private static final Pattern TREE_FILE_LINE_PATTERN = Pattern.compile("^([0-9a-f]{40})\\s+([0-9]+)\\s(.*)$");
    private static char[] byteToHexChar = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private File repositoryLocation;
    private File databaseLocation;

    public Repository(AddOnManager addOnManager) {
        this.repositoryLocation = addOnManager.getOfbizHomeRelativeFile(REPOSITORY_DIR);
        if (!this.repositoryLocation.isDirectory() && !this.repositoryLocation.mkdir()) {
            throw new AddOnManagerException("Unable to create Add-on Repository directory", new Object[0]);
        }
        this.databaseLocation = new File(this.repositoryLocation, DATABASE_DIR);
        if (!this.databaseLocation.isDirectory() && !this.databaseLocation.mkdir()) {
            throw new AddOnManagerException("Unable to create database directory in Add-on Repository", new Object[0]);
        }
    }

    public File getFile(String name) {
        return new File(this.repositoryLocation, name);
    }

    public void checkHash(String hash) {
        if (hash == null || !HASH_PATTERN.matcher(hash).matches()) {
            throw new AddOnManagerException("The given hash '%s' is not a valid sha-1 hash", hash);
        }
    }

    public static String computeHash(File file) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AddOnManagerException("SHA-1 hash algorithm not available on your platform", new Object[]{ex});
        }
        FilterInputStream in = null;
        byte[] digest = null;
        try {
            in = new DigestInputStream(new FileInputStream(file), messageDigest);
            byte[] buffer = new byte[4096];
            while (in.read(buffer) != -1) {
            }
            digest = ((DigestInputStream)in).getMessageDigest().digest();
        }
        catch (Exception ex) {
            throw new AddOnManagerException("An unexpected exception occured while computing hash of file '%s'", file.getAbsolutePath(), ex);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ignoredException) {}
            }
        }
        char[] result = new char[digest.length * 2];
        int i = 0;
        for (byte b : digest) {
            int ub = 0xFF & b;
            result[i++] = byteToHexChar[ub >> 4];
            result[i++] = byteToHexChar[ub & 0xF];
        }
        return new String(result);
    }

    public Tree readTree(String treeId) {
        File treeFile = new File(this.databaseLocation, treeId);
        if (!treeFile.exists()) {
            return null;
        }
        if (!treeFile.isFile() || !treeFile.canRead()) {
            throw new AddOnManagerException("Tree file %s is not a file or is not readable", treeFile.getAbsolutePath());
        }
        BufferedReader reader = null;
        try {
            Tree t = new Tree(this, this.repositoryLocation.getParentFile());
            if (logger.isDebugEnabled()) {
                logger.debug("Reading tree '" + treeFile.getAbsolutePath() + "'");
            }
            reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(treeFile), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                Matcher matcher = TREE_FILE_LINE_PATTERN.matcher(line);
                if (!matcher.matches()) continue;
                String hash = matcher.group(1);
                long lastModifiedDate = Long.parseLong(matcher.group(2));
                String filename = matcher.group(3);
                t.addItem(filename, hash, lastModifiedDate);
            }
            Tree tree = t;
            return tree;
        }
        catch (Exception ex) {
            throw new AddOnManagerException("An unexpected error occured while reading tree file %s", treeFile.getAbsolutePath(), ex);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception ignoredException) {}
            }
        }
    }

    public void writeTree(String treeId, Tree tree) {
        File treeFile = new File(this.databaseLocation, treeId);
        PrintStream out = null;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Writing tree '" + treeFile.getAbsolutePath() + "'");
            }
            out = new PrintStream(treeFile, "UTF-8");
            out.printf("# %1$-38s %2$s %3$s%n", "Hash", "LastModifiedDate", "Filename");
            for (TreeItem item : tree.getItems()) {
                File file = new File(this.repositoryLocation.getParentFile(), item.getPath());
                if (!file.isFile() || !this.storeObject(item.getHash(), new FileInputStream(file))) {
                    // empty if block
                }
                out.printf("%1$s %2$16d %3$s%n", item.getHash(), item.getLastModifiedDate(), item.getPath());
            }
        }
        catch (AddOnManagerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignoredException) {
                    // empty catch block
                }
            }
            out = null;
            treeFile.delete();
            throw new AddOnManagerException("An unexpected error occured during tree writing", new Object[]{ex});
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignoredException) {}
            }
        }
    }

    public void deleteTree(String treeId) {
        File treeFile = new File(this.databaseLocation, treeId);
        if (treeFile.isFile()) {
            if (logger.isDebugEnabled()) {
                logger.debug("Deleting tree '" + treeFile.getAbsolutePath() + "'");
            }
            if (!treeFile.delete()) {
                throw new AddOnManagerException("Unable to delete tree file '%s'", treeFile.getAbsolutePath());
            }
        }
    }

    /*
     * Exception decompiling
     */
    public boolean storeObject(String hash, InputStream in) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public InputStream getObjectReadStream(String hash) {
        this.checkHash(hash);
        String prefix = hash.substring(0, 2);
        String subHash = hash.substring(2);
        File srcDir = new File(this.databaseLocation, prefix);
        if (!this.databaseLocation.exists()) {
            throw new IllegalStateException("repository has not yet been initialized");
        }
        FileInputStream in = null;
        try {
            in = new FileInputStream(new File(srcDir, subHash));
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        return new InflaterInputStream(in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean writeObject(String hash, OutputStream out) throws IOException {
        InputStream in = null;
        try {
            byte[] buffer = new byte[4096];
            int read = 0;
            in = this.getObjectReadStream(hash);
            if (in == null) {
                boolean bl = false;
                return bl;
            }
            while ((read = in.read(buffer)) != -1) {
                out.write(buffer, 0, read);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ignoredException) {}
            }
        }
    }

    public File writeObjectToTemporaryFile(String hash) {
        File tmpFile = null;
        OutputStream out = null;
        boolean successfullWrite = false;
        try {
            tmpFile = File.createTempFile(hash, null);
            tmpFile.deleteOnExit();
            out = new FileOutputStream(tmpFile, false);
            successfullWrite = this.writeObject(hash, out);
            if (!successfullWrite) {
                File file = null;
                return file;
            }
            File file = tmpFile;
            return file;
        }
        catch (Exception ex) {
            throw new AddOnManagerException("An unexpected exception occured while writing object to a temporary file (%s)", hash, ex);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (Exception ignoredException) {}
            }
            if (!successfullWrite && tmpFile != null) {
                tmpFile.delete();
            }
        }
    }
}

