/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeCallers;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.util.DefaultMessageLogger;
import org.apache.ivy.util.cli.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.neogia.addonmanager.AddOnManager;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.AddonDependency;

public class DependencyMgr {
    Ivy ivy;
    Map<String, Integer> ivyLevels = new HashMap<String, Integer>();
    AddOnManager addonManager = null;
    IvySettings settings = null;
    String targetAddonName = null;
    String targetVersion = null;
    File ivyFile = null;
    File ivySettingsFile = null;
    ResolveReport report = null;
    String[] confs;
    boolean fake = false;
    AddonDependency dependenciesTree;
    List<AddonDependency> toInstall;
    public static final Log logger = LogFactory.getLog("addonmanager.dependency");

    public DependencyMgr(String targetName, String version, File settings, AddOnManager addonManager) throws Exception {
        this.targetAddonName = targetName;
        this.targetVersion = version == null ? "latest.integration" : version;
        this.ivyFile = null;
        this.addonManager = addonManager;
        this.ivySettingsFile = settings;
        this.init();
    }

    public DependencyMgr(File ivyFile, File settings, AddOnManager addonManager) throws Exception {
        this.targetAddonName = null;
        this.ivyFile = ivyFile;
        this.addonManager = addonManager;
        this.ivySettingsFile = settings;
        this.init();
    }

    public String getTargetAddon() {
        return this.targetAddonName;
    }

    public String getTreeRootName() {
        if (this.dependenciesTree != null) {
            return this.dependenciesTree.getName();
        }
        return "";
    }

    public AddonDependency createDependency(ModuleDescriptor md) {
        if (md == null) {
            return null;
        }
        String name = this.getNameFromDescriptor(md);
        if (name == null) {
            return null;
        }
        String revision = this.getRevisionFromDescriptor(md);
        if (revision == null) {
            return null;
        }
        return new AddonDependency(name, revision, null);
    }

    public String getRevisionFromDescriptor(ModuleDescriptor md) {
        Artifact[] test = md.getArtifacts("default");
        if (test.length > 0) {
            Artifact test0 = test[0];
            return test0.getId().getRevision();
        }
        return null;
    }

    public String getNameFromDescriptor(ModuleDescriptor md) {
        Artifact[] test = md.getArtifacts("default");
        if (test.length > 0) {
            Artifact test0 = test[0];
            return test0.getName();
        }
        return null;
    }

    public void buildDependecniesTree(ResolveReport report) {
        List dependencies = report.getDependencies();
        ModuleDescriptor rootMd = report.getModuleDescriptor();
        AddonDependency rootAddon = this.createDependency(rootMd);
        boolean isUncomplete = true;
        while (isUncomplete) {
            isUncomplete = false;
            for (IvyNode dpcy : dependencies) {
                IvyNodeCallers.Caller[] callers = dpcy.getCallers("default");
                AddonDependency thisNode = this.createDependency(dpcy.getDescriptor());
                if (thisNode == null) continue;
                for (IvyNodeCallers.Caller caller : callers) {
                    AddonDependency dp = this.createDependency(caller.getModuleDescriptor());
                    AddonDependency thisNodeParent = rootAddon.getNode(dp);
                    List<AddonDependency> parentInstances = rootAddon.getAddonsInstance(dp.getName());
                    if (parentInstances.size() > 0) {
                        for (AddonDependency instance : parentInstances) {
                            if (instance.isChild(thisNode)) continue;
                            instance.addChild(thisNode);
                        }
                        continue;
                    }
                    isUncomplete = true;
                }
            }
        }
        if (rootAddon != null) {
            this.dependenciesTree = rootAddon;
        }
    }

    public List<AddonDependency> retreiveDependencies() throws Exception {
        this.resolve();
        List<AddonDependency> resolvedAddons = new LinkedList<AddonDependency>();
        this.retrieve();
        resolvedAddons = this.getResolvedDependencies(resolvedAddons);
        System.out.println("The dependencies will be installed in this order:");
        this.printToInstall();
        System.out.println("");
        return resolvedAddons;
    }

    public void resolve() throws Exception {
        ResolveOptions resolveOptions = new ResolveOptions().setConfs(this.confs).setValidate(false).setTransitive(true);
        this.report = this.ivy.resolve(this.ivyFile.toURI().toURL(), resolveOptions);
        if (this.report.hasError()) {
            String msg = "";
            Iterator it = this.report.getAllProblemMessages().iterator();
            while (it.hasNext()) {
                msg = msg + it.next().toString();
            }
            throw new AddOnManagerException(msg, new Object[0]);
        }
        this.buildDependecniesTree(this.report);
        System.out.println("dependencies tree as resoled by ivy for the addon : " + this.targetAddonName);
        if (this.fake) {
            this.dependenciesTree.printTree("targetAddon");
        } else {
            this.dependenciesTree.printTree();
        }
    }

    public void printToInstall() {
        int maxLength = 0;
        for (AddonDependency dependecny : this.toInstall) {
            if (dependecny.getName().length() <= maxLength) continue;
            maxLength = dependecny.getName().length();
        }
        for (AddonDependency dependecny : this.toInstall) {
            if ("targetAddon".equals(dependecny.getName())) continue;
            System.out.println("   " + this.appendSapces(dependecny.getName(), maxLength + 15) + " " + dependecny.getRevision());
        }
    }

    public String appendSapces(String line, int length) {
        while (line.length() < length) {
            line = line.concat(" ");
        }
        return line;
    }

    public void retrieve() throws Exception {
        ModuleDescriptor md = this.report.getModuleDescriptor();
        String retrievePattern = this.addonManager.getIvyRepositoryDir().getCanonicalPath().concat("/[artifact]-[revision].zip");
        Map retrieveReport = this.ivy.getRetrieveEngine().determineArtifactsToCopy(md.getModuleRevisionId(), retrievePattern, new RetrieveOptions().setConfs(this.confs).setSync(false).setUseOrigin(false));
        for (ArtifactDownloadReport i : retrieveReport.keySet()) {
            String revision = i.getArtifact().getId().getModuleRevisionId().getRevision();
            String name = i.getArtifact().getId().getModuleRevisionId().getName();
            AddonDependency tmpNode = new AddonDependency(name, revision, null);
            LinkedList<AddonDependency> list = new LinkedList<AddonDependency>();
            this.dependenciesTree.getOrderdDependencies(list);
            for (AddonDependency node : list) {
                if (!node.getName().equals(tmpNode.getName())) continue;
                node.setLocation(i.getLocalFile());
            }
        }
        this.ivy.retrieve(md.getModuleRevisionId(), retrievePattern, new RetrieveOptions().setConfs(this.confs).setSync(false).setUseOrigin(false));
    }

    public void makeIvyFile(String addonName) {
        File tmp = null;
        try {
            this.fake = true;
            tmp = File.createTempFile("ivy", ".xml");
            BufferedWriter output = new BufferedWriter(new FileWriter(tmp));
            StringBuilder sb = new StringBuilder();
            sb.append("<ivy-module version=\"2.0\">");
            sb.append("<info organisation=\"org.neogia\" module=\"targetAddon\" revision=\"1.0\"/>");
            sb.append("<dependencies>");
            sb.append("<dependency org=\"org.neogia\"  name=\"" + addonName + "\" transitive=\"true\" rev=\"" + this.targetVersion + "\"/>");
            sb.append("</dependencies>");
            sb.append("</ivy-module>");
            output.write(sb.toString());
            ((Writer)output).close();
        }
        catch (IOException ex) {
            throw new AddOnManagerException("Could not create initial ivy file at " + tmp.getPath(), new Object[0]);
        }
        this.ivyFile = tmp;
    }

    public List<AddonDependency> getResolvedDependencies(List<AddonDependency> resolvedAddons) {
        AddonDependency.globalPosition = 0;
        this.dependenciesTree.getOrderdDependencies(resolvedAddons);
        for (AddonDependency addon : resolvedAddons) {
            addon.setPosition(resolvedAddons.size() - addon.getPosition());
        }
        HashMap<String, List<AddonDependency>> levels = new HashMap<String, List<AddonDependency>>();
        for (AddonDependency addon : resolvedAddons) {
            int depth = addon.getDepth();
            List<AddonDependency> level = null;
            if (levels.containsKey("" + depth)) {
                level = (List)levels.get("" + depth);
                int index = 0;
                for (AddonDependency dependency : level) {
                    if (addon.getPosition() > dependency.getPosition()) break;
                    ++index;
                }
                level.add(index, addon);
                continue;
            }
            level = new ArrayList<AddonDependency>();
            level.add(0, addon);
            levels.put("" + depth, level);
        }
        Iterator it = levels.keySet().iterator();
        ArrayList<Integer> keys = new ArrayList<Integer>();
        while (it.hasNext()) {
            Integer key = Integer.valueOf((String)it.next());
            keys.add(key);
        }
        Collections.sort(keys, Collections.reverseOrder());
        this.toInstall = new ArrayList<AddonDependency>();
        for (Integer key : keys) {
            List level = (List)levels.get(key.toString());
            for (AddonDependency addon : level) {
                if (this.toInstall.size() >= 1) {
                    if (this.alreadyAdded(this.toInstall, addon)) continue;
                    this.toInstall.add(addon);
                    continue;
                }
                this.toInstall.add(addon);
            }
        }
        return this.toInstall;
    }

    public boolean alreadyAdded(List<AddonDependency> list, AddonDependency addon) {
        for (AddonDependency temp : list) {
            if (!temp.getName().equals(addon.getName())) continue;
            return true;
        }
        return false;
    }

    public void init() throws Exception {
        this.ivy = Ivy.newInstance();
        this.initLevels();
        this.ivy.getLoggerEngine().pushLogger(new DefaultMessageLogger(this.getLevelForIvy()));
        this.ivy.getLoggerEngine().setShowProgress(false);
        this.settings = this.ivy.getSettings();
        this.settings.addAllVariables(System.getProperties());
        this.ivy.configure(this.ivySettingsFile);
        this.ivy.pushContext();
        File cache = new File(this.settings.getDefaultCache().getAbsolutePath());
        if (!cache.exists()) {
            cache.mkdirs();
        } else if (!cache.isDirectory()) {
            throw new ParseException(cache + " is not a directory");
        }
        this.confs = new String[]{"*"};
        if (this.ivyFile == null && this.targetAddonName != null) {
            this.makeIvyFile(this.targetAddonName);
        }
        if (!this.ivyFile.exists()) {
            throw new ParseException("ivy file not found: " + this.ivyFile);
        }
        if (this.ivyFile.isDirectory()) {
            throw new ParseException("ivy file is not a file: " + this.ivyFile);
        }
    }

    public void initLevels() {
        this.ivyLevels.put(Level.INFO.toString(), 2);
        this.ivyLevels.put(Level.ERROR.toString(), 0);
        this.ivyLevels.put(Level.DEBUG.toString(), 4);
        this.ivyLevels.put(Level.TRACE.toString(), 3);
        this.ivyLevels.put(Level.WARN.toString(), 1);
        this.ivyLevels.put(Level.ALL.toString(), 2);
        this.ivyLevels.put(Level.FATAL.toString(), 0);
        this.ivyLevels.put(Level.OFF.toString(), 2);
    }

    public int getLevelForIvy() {
        String level = Logger.getRootLogger().getLevel().toString();
        if (this.ivyLevels.containsKey(level)) {
            return this.ivyLevels.get(level);
        }
        return 2;
    }
}

