/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager;

import java.io.File;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AddonDependency {
    public static final Log logger = LogFactory.getLog("addonmanager.dependency");
    public static int globalPosition;
    private String name;
    private String revision;
    private File location;
    private int depth = 0;
    private int position = 0;
    private AddonDependency parent;
    private List<AddonDependency> childs = new LinkedList<AddonDependency>();

    public AddonDependency() {
    }

    public boolean compareTo(AddonDependency toCompare) {
        if (toCompare == null) {
            return false;
        }
        return this.getName().equals(toCompare.getName()) && this.getRevision().equals(toCompare.getRevision());
    }

    public boolean isChild(AddonDependency dependency) {
        if (this.compareTo(dependency)) {
            return true;
        }
        for (AddonDependency child : this.childs) {
            if (!child.compareTo(dependency)) continue;
            return true;
        }
        return false;
    }

    public void printTree() {
        this.printTree(null);
    }

    public void printTree(String ignore) {
        if (ignore == null || !ignore.equals(this.getName())) {
            System.out.println(this.getIndentation() + " " + this.getName() + " " + this.getRevision());
        }
        for (AddonDependency child : this.childs) {
            child.printTree(ignore);
        }
    }

    public List<AddonDependency> getAddonsInstance(String name) {
        LinkedList<AddonDependency> instances = new LinkedList<AddonDependency>();
        if (name.equals(this.getName())) {
            instances.add(this);
        }
        for (AddonDependency child : this.childs) {
            instances.addAll(child.getAddonsInstance(name));
        }
        return instances;
    }

    public List<AddonDependency> getChilds() {
        return this.childs;
    }

    public void getOrderdDependencies(List<AddonDependency> resolvedAddons) {
        this.position = globalPosition++;
        resolvedAddons.add(0, this);
        for (AddonDependency child : this.childs) {
            child.getOrderdDependencies(resolvedAddons);
        }
    }

    public AddonDependency getNode(String name) {
        AddonDependency node = null;
        if (name.equals(this.getName())) {
            return this;
        }
        for (AddonDependency child : this.childs) {
            node = child.getNode(name);
            if (node == null) continue;
            return node;
        }
        return node;
    }

    public AddonDependency getNode(AddonDependency dependency) {
        return this.getNode(dependency.getName());
    }

    public AddonDependency(String name, String revision, AddonDependency parent) {
        this.name = name;
        this.revision = revision;
        this.parent = parent;
    }

    public String getName() {
        return this.name;
    }

    public File getFile() {
        return this.location;
    }

    public String getRevision() {
        return this.revision;
    }

    public AddonDependency getParent() {
        return this.parent;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setLocation(File location) {
        this.location = location;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getPosition() {
        return this.position;
    }

    public void setRevision(String revision) {
        this.revision = revision;
    }

    public void setParent(AddonDependency parent) {
        this.parent = parent;
    }

    public void addChild(AddonDependency child) {
        this.childs.add(child);
        child.setParent(this);
        child.setDepth(this.getDepth() + 1);
    }

    public void addChilds(List<AddonDependency> childs) {
        for (AddonDependency child : childs) {
            this.addChild(child);
        }
    }

    public String getIndentation() {
        String indentation = "";
        for (int index = 0; index < this.getDepth(); ++index) {
            indentation = indentation.concat("\t");
        }
        return indentation;
    }

    public String toString() {
        return this.name + " (" + this.depth + ") [" + this.revision + "]";
    }
}

