/*
 * Decompiled with CFR 0.152.
 */
package org.neogia.addonmanager;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.neogia.addonmanager.AddOnManagerException;
import org.neogia.addonmanager.Command;
import org.neogia.addonmanager.Repository;
import org.neogia.addonmanager.Tree;
import org.neogia.addonmanager.registry.Registry;

public class AddOnManager {
    public static final Log logger = LogFactory.getLog("addonmanager");
    public static final String version = "20110511";
    public static final String ADDON_MANAGER_DATA_DIR = ".addons";
    public static final String ADDONS_HELP_FILES_DIR = "helpdata";
    public static final String IVY_CACHE_DIR = "ivy-cache";
    public static final String IVY_REPOSITORY_DIR = "repository";
    private static final String DEFAULT_EXCLUDE_FILTERS_FILE = "default-exclude-filters.txt";
    private File ofbizLocation;
    private Repository repository;
    private Registry registry;
    private Set<Pattern> defaultExcludeFiltersPatterns;
    private FileFilter defaultFileFilter;
    public boolean log = false;

    public void setLog(boolean log) {
        this.log = log;
        if (logger.isInfoEnabled() && log) {
            logger.info("addon manager version : 20110511");
            logger.info("Add-On Manager for " + this.ofbizLocation.getAbsolutePath());
        }
    }

    public AddOnManager() {
        this(null);
    }

    public AddOnManager(String ofbizHome) {
        if (logger.isInfoEnabled() && this.log) {
            logger.info("addon manager version : 20110511");
        }
        if (ofbizHome == null && (ofbizHome = System.getProperty("ofbiz.home")) == null) {
            File candidateOfbizHome = new File(System.getProperty("user.dir")).getAbsoluteFile();
            if (logger.isDebugEnabled()) {
                logger.debug("-Dofbiz.home not set, try determining ofbiz location from working directory ...");
            }
            boolean found = false;
            while (!found && candidateOfbizHome != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("Testing " + candidateOfbizHome.getAbsolutePath() + " ...");
                }
                if (found = AddOnManager.isValidOfbizHome(candidateOfbizHome)) continue;
                candidateOfbizHome = candidateOfbizHome.getParentFile();
            }
            if (!found) {
                throw new AddOnManagerException("Unable to determine ofbiz.home", new Object[0]);
            }
            ofbizHome = candidateOfbizHome.getAbsolutePath();
        }
        this.ofbizLocation = new File(ofbizHome).getAbsoluteFile();
        if (!AddOnManager.isValidOfbizHome(this.ofbizLocation)) {
            throw new AddOnManagerException("ofbiz.home does not seem to point to a valid ofbiz installation : '%s'", this.ofbizLocation.getAbsolutePath());
        }
        System.setProperty("ofbiz.home", ofbizHome);
        if (logger.isInfoEnabled() && this.log) {
            logger.info("Add-On Manager for " + this.ofbizLocation.getAbsolutePath());
        }
        this.repository = new Repository(this);
        this.registry = new Registry(this);
    }

    private static boolean isValidOfbizHome(File dir) {
        return new File(dir, ADDON_MANAGER_DATA_DIR).isDirectory() || new File(dir, "framework/entity").isDirectory() || new File(dir, "applications/party").isDirectory();
    }

    public File getOfbizLocation() {
        return this.ofbizLocation;
    }

    public File getDataDir() {
        File dataDir = new File(this.ofbizLocation, ADDON_MANAGER_DATA_DIR);
        if (!dataDir.exists() && !dataDir.mkdir()) {
            throw new AddOnManagerException("Unable to create add-on manager data directory '%s'", dataDir);
        }
        return dataDir;
    }

    public File getHelpDir() {
        File helpDir = new File(this.getDataDir().getPath(), ADDONS_HELP_FILES_DIR);
        if (!helpDir.exists() && !helpDir.mkdir()) {
            throw new AddOnManagerException("Unable to create addons help directory'%s'", helpDir);
        }
        return helpDir;
    }

    public File getIvyCacheDir() {
        File cachrDir = new File(this.getDataDir().getPath(), IVY_CACHE_DIR);
        if (!cachrDir.exists() && !cachrDir.mkdir()) {
            throw new AddOnManagerException("Unable to create ivy-cache directory for add-on manager '%s'", cachrDir);
        }
        return cachrDir;
    }

    public File getIvyRepositoryDir() {
        File ivyRepository = new File(this.getDataDir().getPath(), IVY_REPOSITORY_DIR);
        if (!ivyRepository.exists() && !ivyRepository.mkdir()) {
            throw new AddOnManagerException("Unable to create Ivy repository directory for add-on manager  '%s'", ivyRepository);
        }
        return ivyRepository;
    }

    public void getIvySettingFile() {
        try {
            String line;
            URL ivySettingUrl = new URL(this.getRegistry().getDefaultRepositoryUrl().concat("settings/ivysettings.xml"));
            InputStream is = ivySettingUrl.openStream();
            StringBuilder sb = new StringBuilder();
            BufferedReader reader = new BufferedReader(new InputStreamReader(is));
            File ivysetting = new File(this.getDataDir(), "ivysettings.xml");
            if (!ivysetting.exists()) {
                ivysetting.createNewFile();
            }
            BufferedWriter output = new BufferedWriter(new FileWriter(ivysetting));
            while ((line = reader.readLine()) != null) {
                sb.append(line.concat("\n"));
            }
            output.write(sb.toString());
            ((Writer)output).close();
            is.close();
        }
        catch (Exception ex) {
            logger.warn("Unable to get Ivy Setting File: " + ex.getMessage());
        }
    }

    public File getDataFile(String path) {
        return new File(this.getDataDir(), path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDataDirectoryStructure() {
        File defaultExcludeFiltersFile = this.getDataFile(DEFAULT_EXCLUDE_FILTERS_FILE);
        this.getIvyCacheDir();
        this.getIvyRepositoryDir();
        if (!defaultExcludeFiltersFile.exists()) {
            PrintWriter writer = null;
            try {
                writer = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(defaultExcludeFiltersFile, false), "UTF-8"));
                writer.println("# scm");
                writer.println(".*\\.svn.*");
                writer.println(".*CVS.*");
                writer.println();
                writer.println("# ofbiz generated files");
                writer.println(".*/classes.*");
                writer.println(".*/build/lib/.*\\.jar");
                writer.println(".*/build/lib/.*\\.raj");
                writer.println("runtime/.*");
                writer.println("ofbiz\\.jar");
                writer.println();
                writer.println(".*/modeldef/data/.*");
                writer.println(".*/modeldef/diagrams/.*");
                writer.println(".*/modeldef/thumbs/.*");
                writer.println();
                writer.println("# neogia generated files");
                writer.println(".*/target/.*");
                writer.println(".*/generated/.*");
                writer.println();
                writer.println("# add-on manager folder");
                writer.println("^\\.addons/.*");
                writer.println();
                writer.println("# eclipse build folder");
                writer.println("bin/.*");
                writer.println();
            }
            catch (IOException ex) {
                logger.warn("Unable to write default exclude filters file : " + ex.getMessage(), ex);
            }
            finally {
                if (writer != null) {
                    try {
                        writer.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    public File getOfbizHomeRelativeFile(String path) {
        return new File(this.ofbizLocation, path);
    }

    public Repository getRepository() {
        return this.repository;
    }

    public Registry getRegistry() {
        return this.registry;
    }

    public Tree getCurrentTree() {
        Tree currentTree = new Tree(this.repository, this.ofbizLocation);
        currentTree.load(this.getDefaultExcludeFiltersPattern());
        return currentTree;
    }

    public Map<String, Object> executeCommand(Command command) {
        return command.doExecute(this);
    }

    public Set<Pattern> getDefaultExcludeFiltersPattern() {
        if (this.defaultExcludeFiltersPatterns == null) {
            File defaultExcludeFiltersFile = this.repository.getFile(DEFAULT_EXCLUDE_FILTERS_FILE);
            this.defaultExcludeFiltersPatterns = new LinkedHashSet<Pattern>();
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(defaultExcludeFiltersFile), "UTF-8"));
                String line = null;
                while ((line = reader.readLine()) != null) {
                    if (line.startsWith("#")) continue;
                    try {
                        this.defaultExcludeFiltersPatterns.add(Pattern.compile(line));
                    }
                    catch (PatternSyntaxException ex) {
                        logger.warn("Unable to parse exclude file pattern '" + line + "' : " + ex.getMessage());
                    }
                }
            }
            catch (IOException ex) {
                throw new AddOnManagerException("Unable to read default exclude filters file : %s", ex.getMessage(), ex);
            }
            finally {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception ignoredException) {}
                }
            }
        }
        return Collections.unmodifiableSet(this.defaultExcludeFiltersPatterns);
    }

    public FileFilter getDefaultExcludeFileFilter() {
        if (this.defaultFileFilter == null) {
            final int prefixLength = this.ofbizLocation.getAbsolutePath().length() + 1;
            final Set<Pattern> excludePatterns = this.getDefaultExcludeFiltersPattern();
            this.defaultFileFilter = new FileFilter(){

                @Override
                public boolean accept(File child) {
                    String path = child.getAbsolutePath().substring(prefixLength).replaceAll("\\\\", "/");
                    boolean accept = true;
                    for (Pattern p : excludePatterns) {
                        if (!p.matcher(path).matches()) continue;
                        accept = false;
                        break;
                    }
                    return accept;
                }
            };
        }
        return this.defaultFileFilter;
    }

    public String resolvePathToOfbizHomeRelativePath(String path) {
        return AddOnManager.resolvePathToOfbizHomeRelativePath(this.getOfbizLocation().getAbsolutePath(), System.getProperty("user.dir"), path, System.getProperty("file.separator"));
    }

    static String resolvePathToOfbizHomeRelativePath(String ofbizHome, String userDir, String path, String pathSeparator) {
        File file = new File(path);
        if (!file.isAbsolute()) {
            path = userDir + pathSeparator + path;
        }
        if (!path.startsWith(ofbizHome)) {
            throw new AddOnManagerException("The given path '%s' is not rooted under ofbiz.home '%s'", path, ofbizHome);
        }
        path = path.substring(ofbizHome.length() + pathSeparator.length());
        return path.replaceAll("\\\\", "/");
    }

    public void deletePath(String path) {
        File f = this.getOfbizHomeRelativeFile(path);
        if (f.isFile()) {
            if (!f.delete()) {
                throw new AddOnManagerException("Unable to delete file '%s'", f.getAbsolutePath());
            }
        } else if (f.isDirectory()) {
            File[] children = f.listFiles();
            int prefixCount = this.ofbizLocation.getAbsolutePath().length() + 1;
            for (File child : children) {
                path = child.getAbsolutePath().substring(prefixCount);
                this.deletePath(path);
            }
            if (!f.delete()) {
                throw new AddOnManagerException("Unable to delete directory '%s'", f.getAbsolutePath());
            }
        }
    }

    public void deleteFile(File file) {
        if (!file.getAbsolutePath().startsWith(this.ofbizLocation.getAbsolutePath())) {
            throw new AddOnManagerException("The file to delete is outside of ofbiz tree : '%s'", file.getAbsolutePath());
        }
        this.deletePath(file.getAbsolutePath().substring(this.ofbizLocation.getAbsolutePath().length() + 1));
    }

    public String getVersion() {
        return version;
    }
}

