/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.plugins.resolver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.ivy.core.IvyContext;
import org.apache.ivy.core.cache.ArtifactOrigin;
import org.apache.ivy.core.cache.ModuleDescriptorWriter;
import org.apache.ivy.core.cache.RepositoryCacheManager;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ArtifactDownloadReport;
import org.apache.ivy.core.report.DownloadReport;
import org.apache.ivy.core.report.DownloadStatus;
import org.apache.ivy.core.report.MetadataArtifactDownloadReport;
import org.apache.ivy.core.resolve.DownloadOptions;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.ResolveData;
import org.apache.ivy.core.resolve.ResolvedModuleRevision;
import org.apache.ivy.core.search.ModuleEntry;
import org.apache.ivy.core.search.OrganisationEntry;
import org.apache.ivy.core.search.RevisionEntry;
import org.apache.ivy.plugins.parser.ModuleDescriptorParser;
import org.apache.ivy.plugins.parser.ModuleDescriptorParserRegistry;
import org.apache.ivy.plugins.parser.xml.XmlModuleDescriptorWriter;
import org.apache.ivy.plugins.repository.ArtifactResourceResolver;
import org.apache.ivy.plugins.repository.Resource;
import org.apache.ivy.plugins.repository.ResourceDownloader;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.repository.file.FileResource;
import org.apache.ivy.plugins.repository.url.URLRepository;
import org.apache.ivy.plugins.repository.url.URLResource;
import org.apache.ivy.plugins.resolver.AbstractResolver;
import org.apache.ivy.plugins.resolver.util.MDResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResolvedResource;
import org.apache.ivy.plugins.resolver.util.ResourceMDParser;
import org.apache.ivy.util.Checks;
import org.apache.ivy.util.ChecksumHelper;
import org.apache.ivy.util.HostUtil;
import org.apache.ivy.util.Message;

public abstract class BasicResolver
extends AbstractResolver {
    public static final String DESCRIPTOR_OPTIONAL = "optional";
    public static final String DESCRIPTOR_REQUIRED = "required";
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss");
    private String workspaceName;
    private boolean envDependent = true;
    private List ivyattempts = new ArrayList();
    private Map artattempts = new HashMap();
    private boolean checkconsistency = true;
    private boolean allownomd = true;
    private boolean force = false;
    private String checksums = null;
    private URLRepository extartifactrep = new URLRepository();
    private final ArtifactResourceResolver artifactResourceResolver = new ArtifactResourceResolver(){

        public ResolvedResource resolve(Artifact artifact) {
            artifact = BasicResolver.this.fromSystem(artifact);
            return BasicResolver.this.getArtifactRef(artifact, null);
        }
    };
    private final ResourceDownloader downloader = new ResourceDownloader(){

        public void download(Artifact artifact, Resource resource, File dest) throws IOException {
            if (dest.exists()) {
                dest.delete();
            }
            File part = new File(dest.getAbsolutePath() + ".part");
            if (resource.getName().equals(String.valueOf(artifact.getUrl()))) {
                if (part.getParentFile() != null) {
                    part.getParentFile().mkdirs();
                }
                BasicResolver.this.extartifactrep.get(resource.getName(), part);
            } else {
                BasicResolver.this.getAndCheck(resource, part);
            }
            if (!part.renameTo(dest)) {
                throw new IOException("impossible to move part file to definitive one: " + part + " -> " + dest);
            }
        }
    };

    public BasicResolver() {
        this.workspaceName = HostUtil.getLocalHostName();
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public void setWorkspaceName(String workspaceName) {
        this.workspaceName = workspaceName;
    }

    public boolean isEnvDependent() {
        return this.envDependent;
    }

    public void setEnvDependent(boolean envDependent) {
        this.envDependent = envDependent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResolvedModuleRevision getDependency(DependencyDescriptor dd, ResolveData data) throws ParseException {
        IvyContext context = IvyContext.pushNewCopyContext();
        try {
            ResolvedModuleRevision mr = data.getCurrentResolvedModuleRevision();
            if (mr != null && this.shouldReturnResolvedModule(dd, mr)) {
                ResolvedModuleRevision resolvedModuleRevision = mr;
                return resolvedModuleRevision;
            }
            if (this.isForce()) {
                dd = dd.clone(ModuleRevisionId.newInstance(dd.getDependencyRevisionId(), "latest.integration"));
            }
            DependencyDescriptor systemDd = dd;
            DependencyDescriptor nsDd = this.fromSystem(dd);
            context.setDependencyDescriptor(systemDd);
            context.setResolveData(data);
            this.clearIvyAttempts();
            this.clearArtifactAttempts();
            ModuleRevisionId systemMrid = systemDd.getDependencyRevisionId();
            ModuleRevisionId nsMrid = nsDd.getDependencyRevisionId();
            this.checkRevision(systemMrid);
            boolean isDynamic = this.getAndCheckIsDynamic(systemMrid);
            ResolvedModuleRevision rmr = null;
            rmr = this.findModuleInCache(systemDd, data);
            if (rmr != null) {
                if (rmr.getDescriptor().isDefault() && rmr.getResolver() != this) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + systemMrid + " (resolved by " + rmr.getResolver().getName() + "): but it's a default one, maybe we can find a better one");
                } else if (this.isForce() && rmr.getResolver() != this) {
                    Message.verbose("\t" + this.getName() + ": found revision in cache: " + systemMrid + " (resolved by " + rmr.getResolver().getName() + "): but we are in force mode, let's try to find one ourself");
                } else {
                    Message.verbose("\t" + this.getName() + ": revision in cache: " + systemMrid);
                    ResolvedModuleRevision resolvedModuleRevision = this.checkLatest(this.checkForcedResolvedModuleRevision(rmr), data);
                    return resolvedModuleRevision;
                }
            }
            this.checkInterrupted();
            ResolvedResource ivyRef = this.findIvyFileRef(nsDd, data);
            this.checkInterrupted();
            ModuleDescriptor systemMd = null;
            if (ivyRef == null) {
                if (!this.isAllownomd()) {
                    throw new UnresolvedDependencyException("\t" + this.getName() + ": no ivy file found for " + systemMrid, false);
                }
                DefaultModuleDescriptor nsMd = DefaultModuleDescriptor.newDefaultInstance(nsMrid, nsDd.getAllDependencyArtifacts());
                ResolvedResource artifactRef = this.findFirstArtifactRef(nsMd, nsDd, data);
                this.checkInterrupted();
                if (artifactRef == null) {
                    throw new UnresolvedDependencyException("\t" + this.getName() + ": no ivy file nor artifact found for " + systemMrid, false);
                }
                long lastModified = artifactRef.getLastModified();
                if (lastModified != 0L && nsMd instanceof DefaultModuleDescriptor) {
                    nsMd.setLastModified(lastModified);
                }
                Message.verbose("\t" + this.getName() + ": no ivy file found for " + systemMrid + ": using default data");
                if (isDynamic) {
                    nsMd.setResolvedModuleRevisionId(ModuleRevisionId.newInstance(nsMrid, artifactRef.getRevision()));
                }
                systemMd = this.toSystem(nsMd);
                MetadataArtifactDownloadReport madr = new MetadataArtifactDownloadReport(systemMd.getMetadataArtifact());
                madr.setDownloadStatus(DownloadStatus.NO);
                madr.setSearched(true);
                rmr = new ResolvedModuleRevision(this, this, systemMd, madr, this.isForce());
            } else {
                if (ivyRef instanceof MDResolvedResource) {
                    rmr = ((MDResolvedResource)ivyRef).getResolvedModuleRevision();
                }
                if (rmr == null && (rmr = this.parse(ivyRef, systemDd, data)) == null) {
                    throw new UnresolvedDependencyException();
                }
                if (!rmr.getReport().isDownloaded() && rmr.getReport().getLocalFile() != null) {
                    ResolvedModuleRevision artifactRef = this.checkLatest(this.checkForcedResolvedModuleRevision(rmr), data);
                    return artifactRef;
                }
                ModuleDescriptor nsMd = rmr.getDescriptor();
                systemMd = this.toSystem(nsMd);
                if (this.isCheckconsistency()) {
                    this.checkDescriptorConsistency(systemMrid, systemMd, ivyRef);
                    this.checkDescriptorConsistency(nsMrid, nsMd, ivyRef);
                } else if (systemMd instanceof DefaultModuleDescriptor) {
                    DefaultModuleDescriptor defaultMd = (DefaultModuleDescriptor)systemMd;
                    ModuleRevisionId revision = this.getRevision(ivyRef, systemMrid, systemMd);
                    defaultMd.setModuleRevisionId(revision);
                    defaultMd.setResolvedModuleRevisionId(revision);
                } else {
                    Message.warn("consistency disabled with instance of non DefaultModuleDescriptor... module info can't be updated, so consistency check will be done");
                    this.checkDescriptorConsistency(nsMrid, nsMd, ivyRef);
                    this.checkDescriptorConsistency(systemMrid, systemMd, ivyRef);
                }
                rmr = new ResolvedModuleRevision(this, this, systemMd, this.toSystem(rmr.getReport()), this.isForce());
            }
            this.resolveAndCheckRevision(systemMd, systemMrid, ivyRef, isDynamic);
            this.resolveAndCheckPublicationDate(systemDd, systemMd, systemMrid, data);
            this.checkNotConvertedExclusionRule(systemMd, ivyRef, data);
            this.cacheModuleDescriptor(systemMd, systemMrid, ivyRef, rmr);
            ResolvedModuleRevision resolvedModuleRevision = this.checkLatest(this.checkForcedResolvedModuleRevision(rmr), data);
            return resolvedModuleRevision;
        }
        catch (UnresolvedDependencyException ex) {
            if (ex.getMessage().length() > 0) {
                if (ex.isError()) {
                    Message.error(ex.getMessage());
                } else {
                    Message.verbose(ex.getMessage());
                }
            }
            ResolvedModuleRevision resolvedModuleRevision = data.getCurrentResolvedModuleRevision();
            return resolvedModuleRevision;
        }
        finally {
            IvyContext.popContext();
        }
    }

    protected boolean shouldReturnResolvedModule(DependencyDescriptor dd, ResolvedModuleRevision mr) {
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        boolean isDynamic = this.getSettings().getVersionMatcher().isDynamic(mrid);
        boolean shouldReturn = mr.isForce();
        shouldReturn |= !isDynamic && !mr.getDescriptor().isDefault();
        return shouldReturn &= !this.isForce();
    }

    private ResolvedModuleRevision checkForcedResolvedModuleRevision(ResolvedModuleRevision rmr) {
        if (rmr == null) {
            return null;
        }
        if (!this.isForce() || rmr.isForce()) {
            return rmr;
        }
        return new ResolvedModuleRevision(rmr.getResolver(), rmr.getArtifactResolver(), rmr.getDescriptor(), rmr.getReport(), true);
    }

    private void cacheModuleDescriptor(ModuleDescriptor systemMd, ModuleRevisionId systemMrid, ResolvedResource ivyRef, ResolvedModuleRevision rmr) {
        RepositoryCacheManager cacheManager = this.getRepositoryCacheManager();
        final ModuleDescriptorParser parser = systemMd.getParser();
        Artifact requestedMetadataArtifact = ivyRef == null ? systemMd.getMetadataArtifact() : parser.getMetadataArtifact(ModuleRevisionId.newInstance(systemMrid, ivyRef.getRevision()), ivyRef.getResource());
        cacheManager.originalToCachedModuleDescriptor(this, ivyRef, requestedMetadataArtifact, rmr, new ModuleDescriptorWriter(){

            public void write(ResolvedResource originalMdResource, ModuleDescriptor md, File src, File dest) throws IOException, ParseException {
                if (originalMdResource == null) {
                    XmlModuleDescriptorWriter.write(md, dest);
                } else {
                    parser.toIvyFile(new FileInputStream(src), originalMdResource.getResource(), dest, md);
                    long repLastModified = originalMdResource.getLastModified();
                    if (repLastModified > 0L) {
                        dest.setLastModified(repLastModified);
                    }
                }
            }
        });
    }

    private void checkNotConvertedExclusionRule(ModuleDescriptor systemMd, ResolvedResource ivyRef, ResolveData data) {
        DefaultModuleDescriptor dmd;
        if (!systemMd.isDefault() && data.getSettings().logNotConvertedExclusionRule() && systemMd instanceof DefaultModuleDescriptor && (dmd = (DefaultModuleDescriptor)systemMd).isNamespaceUseful()) {
            Message.warn("the module descriptor " + ivyRef.getResource() + " has information which can't be converted into " + "the system namespace. " + "It will require the availability of the namespace '" + this.getNamespace().getName() + "' to be fully usable.");
        }
    }

    private void resolveAndCheckPublicationDate(DependencyDescriptor systemDd, ModuleDescriptor systemMd, ModuleRevisionId systemMrid, ResolveData data) {
        if (data.getDate() != null) {
            long pubDate = this.getPublicationDate(systemMd, systemDd, data);
            if (pubDate > data.getDate().getTime()) {
                throw new UnresolvedDependencyException("\t" + this.getName() + ": unacceptable publication date => was=" + new Date(pubDate) + " required=" + data.getDate());
            }
            if (pubDate == -1L) {
                throw new UnresolvedDependencyException("\t" + this.getName() + ": impossible to guess publication date: artifact missing for " + systemMrid);
            }
            systemMd.setResolvedPublicationDate(new Date(pubDate));
        }
    }

    private void checkModuleDescriptorRevision(ModuleDescriptor systemMd, ModuleRevisionId systemMrid) {
        if (!this.getSettings().getVersionMatcher().accept(systemMrid, systemMd)) {
            throw new UnresolvedDependencyException("\t" + this.getName() + ": unacceptable revision => was=" + systemMd.getResolvedModuleRevisionId().getRevision() + " required=" + systemMrid.getRevision());
        }
    }

    private boolean getAndCheckIsDynamic(ModuleRevisionId systemMrid) {
        boolean isDynamic = this.getSettings().getVersionMatcher().isDynamic(systemMrid);
        if (isDynamic && !this.acceptLatest()) {
            throw new UnresolvedDependencyException("dynamic revisions not handled by " + this.getClass().getName() + ". impossible to resolve " + systemMrid);
        }
        return isDynamic;
    }

    private void checkRevision(ModuleRevisionId systemMrid) {
        int index = systemMrid.getRevision().indexOf("@");
        if (index != -1 && !systemMrid.getRevision().substring(index + 1).equals(this.workspaceName)) {
            throw new UnresolvedDependencyException("\t" + this.getName() + ": unhandled revision => " + systemMrid.getRevision());
        }
    }

    private void resolveAndCheckRevision(ModuleDescriptor systemMd, ModuleRevisionId dependencyConstraint, ResolvedResource ivyRef, boolean isDynamic) {
        ModuleRevisionId resolvedMrid = systemMd.getResolvedModuleRevisionId();
        if (resolvedMrid.getRevision() == null || resolvedMrid.getRevision().length() == 0 || resolvedMrid.getRevision().startsWith("working@")) {
            resolvedMrid = !isDynamic ? ModuleRevisionId.newInstance(resolvedMrid, dependencyConstraint.getRevision()) : (ivyRef == null ? systemMd.getMetadataArtifact().getModuleRevisionId() : (ivyRef.getRevision() == null || ivyRef.getRevision().length() == 0 ? ModuleRevisionId.newInstance(resolvedMrid, "working@" + this.getName()) : ModuleRevisionId.newInstance(resolvedMrid, ivyRef.getRevision())));
        }
        if (isDynamic) {
            Message.verbose("\t\t[" + this.toSystem(resolvedMrid).getRevision() + "] " + dependencyConstraint.getModuleId());
        }
        systemMd.setResolvedModuleRevisionId(resolvedMrid);
        this.checkModuleDescriptorRevision(systemMd, dependencyConstraint);
    }

    private ModuleRevisionId getRevision(ResolvedResource ivyRef, ModuleRevisionId askedMrid, ModuleDescriptor md) throws ParseException {
        HashMap allAttributes = new HashMap();
        allAttributes.putAll(md.getQualifiedExtraAttributes());
        allAttributes.putAll(askedMrid.getQualifiedExtraAttributes());
        String revision = ivyRef.getRevision();
        if (revision == null) {
            Message.debug("no revision found in reference for " + askedMrid);
            if (this.getSettings().getVersionMatcher().isDynamic(askedMrid)) {
                if (md.getModuleRevisionId().getRevision() == null) {
                    revision = "working@" + this.getName();
                } else {
                    Message.debug("using " + askedMrid);
                    revision = askedMrid.getRevision();
                }
            } else {
                Message.debug("using " + askedMrid);
                revision = askedMrid.getRevision();
            }
        }
        return ModuleRevisionId.newInstance(askedMrid.getOrganisation(), askedMrid.getName(), askedMrid.getBranch(), revision, allAttributes);
    }

    public ResolvedModuleRevision parse(ResolvedResource mdRef, DependencyDescriptor dd, ResolveData data) throws ParseException {
        IvyNode node;
        DependencyDescriptor nsDd = dd;
        dd = this.toSystem(nsDd);
        ModuleRevisionId mrid = dd.getDependencyRevisionId();
        ModuleDescriptorParser parser = ModuleDescriptorParserRegistry.getInstance().getParser(mdRef.getResource());
        if (parser == null) {
            Message.warn("no module descriptor parser available for " + mdRef.getResource());
            return null;
        }
        Message.verbose("\t" + this.getName() + ": found md file for " + mrid);
        Message.verbose("\t\t=> " + mdRef);
        Message.debug("\tparser = " + parser);
        ModuleRevisionId resolvedMrid = mrid;
        if (this.getSettings().getVersionMatcher().isDynamic(mrid) && (node = data.getNode(resolvedMrid = ModuleRevisionId.newInstance(mrid, mdRef.getRevision()))) != null && node.getModuleRevision() != null) {
            if (node.getDescriptor() != null && node.getDescriptor().isDefault()) {
                Message.verbose("\t" + this.getName() + ": found already resolved revision: " + resolvedMrid + ": but it's a default one, maybe we can find a better one");
            } else {
                Message.verbose("\t" + this.getName() + ": revision already resolved: " + resolvedMrid);
                node.getModuleRevision().getReport().setSearched(true);
                return node.getModuleRevision();
            }
        }
        Artifact moduleArtifact = parser.getMetadataArtifact(resolvedMrid, mdRef.getResource());
        return this.getRepositoryCacheManager().cacheModuleDescriptor(this, mdRef, dd, moduleArtifact, this.downloader, this.getCacheOptions(data));
    }

    protected ResourceMDParser getRMDParser(final DependencyDescriptor dd, final ResolveData data) {
        return new ResourceMDParser(){

            public MDResolvedResource parse(Resource resource, String rev) {
                try {
                    ResolvedModuleRevision rmr = BasicResolver.this.parse(new ResolvedResource(resource, rev), dd, data);
                    if (rmr == null) {
                        return null;
                    }
                    return new MDResolvedResource(resource, rev, rmr);
                }
                catch (ParseException e) {
                    Message.warn("Failed to parse the file '" + resource + "': " + e.getMessage());
                    return null;
                }
            }
        };
    }

    protected ResourceMDParser getDefaultRMDParser(final ModuleId mid) {
        return new ResourceMDParser(){

            public MDResolvedResource parse(Resource resource, String rev) {
                DefaultModuleDescriptor md = DefaultModuleDescriptor.newDefaultInstance(new ModuleRevisionId(mid, rev));
                MetadataArtifactDownloadReport madr = new MetadataArtifactDownloadReport(md.getMetadataArtifact());
                madr.setDownloadStatus(DownloadStatus.NO);
                madr.setSearched(true);
                return new MDResolvedResource(resource, rev, new ResolvedModuleRevision(BasicResolver.this, BasicResolver.this, md, madr, BasicResolver.this.isForce()));
            }
        };
    }

    private void checkDescriptorConsistency(ModuleRevisionId mrid, ModuleDescriptor md, ResolvedResource ivyRef) throws ParseException {
        boolean ok = true;
        StringBuffer errors = new StringBuffer();
        if (!mrid.getOrganisation().equals(md.getModuleRevisionId().getOrganisation())) {
            Message.error("\t" + this.getName() + ": bad organisation found in " + ivyRef.getResource() + ": expected='" + mrid.getOrganisation() + "' found='" + md.getModuleRevisionId().getOrganisation() + "'");
            errors.append("bad organisation: expected='" + mrid.getOrganisation() + "' found='" + md.getModuleRevisionId().getOrganisation() + "'; ");
            ok = false;
        }
        if (!mrid.getName().equals(md.getModuleRevisionId().getName())) {
            Message.error("\t" + this.getName() + ": bad module name found in " + ivyRef.getResource() + ": expected='" + mrid.getName() + " found='" + md.getModuleRevisionId().getName() + "'");
            errors.append("bad module name: expected='" + mrid.getName() + "' found='" + md.getModuleRevisionId().getName() + "'; ");
            ok = false;
        }
        if (mrid.getBranch() != null && !mrid.getBranch().equals(md.getModuleRevisionId().getBranch())) {
            Message.error("\t" + this.getName() + ": bad branch name found in " + ivyRef.getResource() + ": expected='" + mrid.getBranch() + " found='" + md.getModuleRevisionId().getBranch() + "'");
            errors.append("bad branch name: expected='" + mrid.getBranch() + "' found='" + md.getModuleRevisionId().getBranch() + "'; ");
            ok = false;
        }
        if (ivyRef.getRevision() != null && !ivyRef.getRevision().startsWith("working@")) {
            ModuleRevisionId expectedMrid = ModuleRevisionId.newInstance(mrid, ivyRef.getRevision());
            if (!this.getSettings().getVersionMatcher().accept(expectedMrid, md)) {
                Message.error("\t" + this.getName() + ": bad revision found in " + ivyRef.getResource() + ": expected='" + ivyRef.getRevision() + " found='" + md.getModuleRevisionId().getRevision() + "'");
                errors.append("bad revision: expected='" + ivyRef.getRevision() + "' found='" + md.getModuleRevisionId().getRevision() + "'; ");
                ok = false;
            }
        }
        if (!this.getSettings().getStatusManager().isStatus(md.getStatus())) {
            Message.error("\t" + this.getName() + ": bad status found in " + ivyRef.getResource() + ": '" + md.getStatus() + "'");
            errors.append("bad status: '" + md.getStatus() + "'; ");
            ok = false;
        }
        Iterator it = mrid.getExtraAttributes().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry extra = it.next();
            if (extra.getValue() == null || extra.getValue().equals(md.getExtraAttribute((String)extra.getKey()))) continue;
            String errorMsg = "bad " + extra.getKey() + " found in " + ivyRef.getResource() + ": expected='" + extra.getValue() + "' found='" + md.getExtraAttribute((String)extra.getKey()) + "'";
            Message.error("\t" + this.getName() + ": " + errorMsg);
            errors.append(errorMsg + ";");
            ok = false;
        }
        if (!ok) {
            throw new ParseException("inconsistent module descriptor file found in '" + ivyRef.getResource() + "': " + errors, 0);
        }
    }

    protected void clearIvyAttempts() {
        this.ivyattempts.clear();
        this.clearArtifactAttempts();
    }

    protected void logIvyAttempt(String attempt) {
        this.ivyattempts.add(attempt);
        Message.verbose("\t\ttried " + attempt);
    }

    protected void logArtifactAttempt(Artifact art, String attempt) {
        ArrayList<String> attempts = (ArrayList<String>)this.artattempts.get(art);
        if (attempts == null) {
            attempts = new ArrayList<String>();
            this.artattempts.put(art, attempts);
        }
        attempts.add(attempt);
        Message.verbose("\t\ttried " + attempt);
    }

    protected void logAttempt(String attempt) {
        Artifact currentArtifact = (Artifact)IvyContext.getContext().get(this.getName() + ".artifact");
        if (currentArtifact != null) {
            this.logArtifactAttempt(currentArtifact, attempt);
        } else {
            this.logIvyAttempt(attempt);
        }
    }

    public void reportFailure() {
        Message.warn("==== " + this.getName() + ": tried");
        Iterator<Object> iter = this.ivyattempts.listIterator();
        while (iter.hasNext()) {
            String m = (String)iter.next();
            Message.warn("  " + m);
        }
        iter = this.artattempts.keySet().iterator();
        while (iter.hasNext()) {
            Artifact art = (Artifact)iter.next();
            List attempts = (List)this.artattempts.get(art);
            if (attempts == null) continue;
            Message.warn("  -- artifact " + art + ":");
            ListIterator iterator = attempts.listIterator();
            while (iterator.hasNext()) {
                String m = (String)iterator.next();
                Message.warn("  " + m);
            }
        }
    }

    public void reportFailure(Artifact art) {
        Message.warn("==== " + this.getName() + ": tried");
        List attempts = (List)this.artattempts.get(art);
        if (attempts != null) {
            ListIterator iter = attempts.listIterator();
            while (iter.hasNext()) {
                String m = (String)iter.next();
                Message.warn("  " + m);
            }
        }
    }

    protected boolean acceptLatest() {
        return true;
    }

    public DownloadReport download(Artifact[] artifacts, DownloadOptions options) {
        RepositoryCacheManager cacheManager = this.getRepositoryCacheManager();
        this.clearArtifactAttempts();
        DownloadReport dr = new DownloadReport();
        for (int i = 0; i < artifacts.length; ++i) {
            ArtifactDownloadReport adr = cacheManager.download(artifacts[i], this.artifactResourceResolver, this.downloader, this.getCacheDownloadOptions(options));
            if (DownloadStatus.FAILED == adr.getDownloadStatus()) {
                if (!"missing artifact".equals(adr.getDownloadDetails())) {
                    Message.warn("\t" + adr);
                }
            } else if (DownloadStatus.NO == adr.getDownloadStatus()) {
                Message.verbose("\t" + adr);
            } else if ("quiet".equals(options.getLog())) {
                Message.verbose("\t" + adr);
            } else {
                Message.info("\t" + adr);
            }
            dr.addArtifactReport(adr);
            this.checkInterrupted();
        }
        return dr;
    }

    protected void clearArtifactAttempts() {
        this.artattempts.clear();
    }

    public ArtifactDownloadReport download(final ArtifactOrigin origin, DownloadOptions options) {
        Checks.checkNotNull(origin, "origin");
        return this.getRepositoryCacheManager().download(origin.getArtifact(), new ArtifactResourceResolver(){

            public ResolvedResource resolve(Artifact artifact) {
                try {
                    Resource resource = BasicResolver.this.getResource(origin.getLocation());
                    if (resource == null) {
                        return null;
                    }
                    String revision = origin.getArtifact().getModuleRevisionId().getRevision();
                    return new ResolvedResource(resource, revision);
                }
                catch (IOException e) {
                    return null;
                }
            }
        }, this.downloader, this.getCacheDownloadOptions(options));
    }

    protected abstract Resource getResource(String var1) throws IOException;

    public boolean exists(Artifact artifact) {
        ResolvedResource artifactRef = this.getArtifactRef(artifact, null);
        if (artifactRef != null) {
            return artifactRef.getResource().exists();
        }
        return false;
    }

    public ArtifactOrigin locate(Artifact artifact) {
        ArtifactOrigin origin = this.getRepositoryCacheManager().getSavedArtifactOrigin(artifact);
        if (!ArtifactOrigin.isUnknown(origin)) {
            return origin;
        }
        ResolvedResource artifactRef = this.getArtifactRef(artifact, null);
        if (artifactRef != null && artifactRef.getResource().exists()) {
            return new ArtifactOrigin(artifact, artifactRef.getResource().isLocal(), artifactRef.getResource().getName());
        }
        return null;
    }

    protected long getPublicationDate(ModuleDescriptor md, DependencyDescriptor dd, ResolveData data) {
        if (md.getPublicationDate() != null) {
            return md.getPublicationDate().getTime();
        }
        ResolvedResource artifactRef = this.findFirstArtifactRef(md, dd, data);
        if (artifactRef != null) {
            return artifactRef.getLastModified();
        }
        return -1L;
    }

    public String toString() {
        return this.getName();
    }

    public String[] listTokenValues(String token, Map otherTokenValues) {
        Collection ret = this.findNames(otherTokenValues, token);
        return ret.toArray(new String[ret.size()]);
    }

    public OrganisationEntry[] listOrganisations() {
        Collection names = this.findNames(Collections.EMPTY_MAP, "organisation");
        OrganisationEntry[] ret = new OrganisationEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String org = (String)iter.next();
            ret[i] = new OrganisationEntry(this, org);
            ++i;
        }
        return ret;
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", org.getOrganisation());
        Collection names = this.findNames(tokenValues, "module");
        ModuleEntry[] ret = new ModuleEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ret[i] = new ModuleEntry(org, name);
            ++i;
        }
        return ret;
    }

    public RevisionEntry[] listRevisions(ModuleEntry mod) {
        HashMap<String, String> tokenValues = new HashMap<String, String>();
        tokenValues.put("organisation", mod.getOrganisation());
        tokenValues.put("module", mod.getModule());
        Collection names = this.findNames(tokenValues, "revision");
        RevisionEntry[] ret = new RevisionEntry[names.size()];
        int i = 0;
        Iterator iter = names.iterator();
        while (iter.hasNext()) {
            String name = (String)iter.next();
            ret[i] = new RevisionEntry(mod, name);
            ++i;
        }
        return ret;
    }

    protected abstract Collection findNames(Map var1, String var2);

    protected ResolvedResource findFirstArtifactRef(ModuleDescriptor md, DependencyDescriptor dd, ResolveData data) {
        ResolvedResource ret = null;
        String[] conf = md.getConfigurationsNames();
        for (int i = 0; i < conf.length; ++i) {
            Artifact[] artifacts = md.getArtifacts(conf[i]);
            for (int j = 0; j < artifacts.length; ++j) {
                ret = this.getArtifactRef(artifacts[j], data.getDate());
                if (ret == null) continue;
                return ret;
            }
        }
        return null;
    }

    protected long getAndCheck(Resource resource, File dest) throws IOException {
        long size = this.get(resource, dest);
        String[] checksums = this.getChecksumAlgorithms();
        boolean checked = false;
        for (int i = 0; i < checksums.length && !checked; ++i) {
            checked = this.check(resource, dest, checksums[i]);
        }
        return size;
    }

    private boolean check(Resource resource, File dest, String algorithm) throws IOException {
        Resource csRes = resource.clone(resource.getName() + "." + algorithm);
        if (csRes.exists()) {
            Message.debug(algorithm + " file found for " + resource + ": checking...");
            File csFile = File.createTempFile("ivytmp", algorithm);
            try {
                this.get(csRes, csFile);
                try {
                    ChecksumHelper.check(dest, csFile, algorithm);
                    Message.verbose(algorithm + " OK for " + resource);
                    boolean bl = true;
                    return bl;
                }
                catch (IOException ex) {
                    dest.delete();
                    throw ex;
                }
            }
            finally {
                csFile.delete();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ResolvedResource getArtifactRef(Artifact artifact, Date date) {
        IvyContext.getContext().set(this.getName() + ".artifact", artifact);
        try {
            ResolvedResource ret = this.findArtifactRef(artifact, date);
            if (ret == null && artifact.getUrl() != null) {
                URL url = artifact.getUrl();
                Message.verbose("\tusing url for " + artifact + ": " + url);
                this.logArtifactAttempt(artifact, url.toExternalForm());
                Resource resource = "file".equals(url.getProtocol()) ? new FileResource(new FileRepository(), new File(url.getPath())) : new URLResource(url);
                ret = new ResolvedResource(resource, artifact.getModuleRevisionId().getRevision());
            }
            ResolvedResource resolvedResource = ret;
            return resolvedResource;
        }
        finally {
            IvyContext.getContext().set(this.getName() + ".artifact", null);
        }
    }

    protected abstract ResolvedResource findArtifactRef(Artifact var1, Date var2);

    protected abstract long get(Resource var1, File var2) throws IOException;

    public boolean isCheckconsistency() {
        return this.checkconsistency;
    }

    public void setCheckconsistency(boolean checkConsitency) {
        this.checkconsistency = checkConsitency;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isAllownomd() {
        return this.allownomd;
    }

    public void setAllownomd(boolean b) {
        Message.deprecated("allownomd is deprecated, please use descriptor=\"" + (b ? DESCRIPTOR_OPTIONAL : DESCRIPTOR_REQUIRED) + "\" instead");
        this.allownomd = b;
    }

    public void setDescriptor(String descriptorRule) {
        if (DESCRIPTOR_REQUIRED.equals(descriptorRule)) {
            this.allownomd = false;
        } else if (DESCRIPTOR_OPTIONAL.equals(descriptorRule)) {
            this.allownomd = true;
        } else {
            throw new IllegalArgumentException("unknown descriptor rule '" + descriptorRule + "'. Allowed rules are: " + Arrays.asList(DESCRIPTOR_REQUIRED, DESCRIPTOR_OPTIONAL));
        }
    }

    public String[] getChecksumAlgorithms() {
        String csDef;
        String string = csDef = this.checksums == null ? this.getSettings().getVariable("ivy.checksums") : this.checksums;
        if (csDef == null) {
            return new String[0];
        }
        String[] checksums = csDef.split(",");
        ArrayList<String> algos = new ArrayList<String>();
        for (int i = 0; i < checksums.length; ++i) {
            String cs = checksums[i].trim();
            if ("".equals(cs) || "none".equals(cs)) continue;
            algos.add(cs);
        }
        return algos.toArray(new String[algos.size()]);
    }

    public void setChecksums(String checksums) {
        this.checksums = checksums;
    }

    private static class UnresolvedDependencyException
    extends RuntimeException {
        private boolean error;

        public UnresolvedDependencyException() {
            this("", false);
        }

        public UnresolvedDependencyException(String message) {
            this(message, true);
        }

        public UnresolvedDependencyException(String message, boolean error) {
            super(message);
            this.error = error;
        }

        public boolean isError() {
            return this.error;
        }
    }
}

