/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * This is completely derived from TinyScheme 1.33 even though
 * the source code literally seems not like that ;-).
 *
 * $Id: ts_main.c,v 1.4 2003/12/29 18:44:36 fuyu Exp $
 */

/* T I N Y S C H E M E    1 . 3 3
 *   Dimitrios Souflis (dsouflis@acm.org)
 *   Based on MiniScheme (original credits follow)
 * (MINISCM)               coded by Atsushi Moriwaki (11/5/1989)
 * (MINISCM)           E-MAIL :  moriwaki@kurims.kurims.kyoto-u.ac.jp
 * (MINISCM) This version has been modified by R.C. Secrist.
 * (MINISCM)
 * (MINISCM) Mini-Scheme is now maintained by Akira KIDA.
 * (MINISCM)
 * (MINISCM) This is a revised and modified version by Akira KIDA.
 * (MINISCM)	current version is 0.85k4 (15 May 1994)
 *
 */

/*
 * LICENSE TERMS
 *
 * Copyright (c) 2000, Dimitrios Souflis
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 *
 * Redistributions in binary form must reproduce the above copyright
 * notice, this list of conditions and the following disclaimer in the
 * documentation and/or other materials provided with the distribution.
 *
 * Neither the name of Dimitrios Souflis nor the names of the
 * contributors may be used to endorse or promote products derived from
 * this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR 
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE REGENTS OR 
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, 
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR 
 * PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF 
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING 
 * NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */

#include "ts_engine.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>


#define InitFile	"init.scm"
#define banner		"TinyScheme 1.33 (libtsengine)"


int
main(int argc, char *argv[])
{
  TSEngine *engine;
  const char *file_name = InitFile;
  int retcode = 0;
  int isfile = 1;
  
  if (argc == 1)
    printf(banner);

  if (argc == 2 && strcmp(argv[1], "-?") == 0)
    {
      fprintf(stderr, "Usage: %s [-? | <file1> <file2> ... | -1 <file> <arg1> <arg2> ...]\n\tUse - as filename for stdin.\n", argv[0]);
      return 1;
    }

  g_type_init();

  engine = ts_engine_new(FALSE);
  if (engine->is_busy)
    {
      fprintf(stderr, "Could not initialize!\n");
      g_object_unref(G_OBJECT(engine));

      return 2;
    }

  ts_engine_set_input_file(engine, stdin);
  ts_engine_set_output_file(engine, stdout);
#if USE_DL
  {
    TSCellHandle *ff = ts_engine_mk_cell_foreign_func(engine, scm_load_ext);
    ts_engine_define_global(engine, "load-extension", ff);
    g_object_unref(G_OBJECT(ff));
  }
#endif

  argv++;
  if (access(file_name, 0) != 0)
    {
      char *p = getenv("TINYSCHEMEINIT");
      if (p != NULL)
	file_name = p;
    }
  do
    {
      FILE *fin = NULL;

      if (strcmp(file_name, "-") == 0)
	fin = stdin;
      else if (strcmp(file_name, "-1") == 0 || strcmp(file_name, "-c") == 0)
	{
	  TSCellHandle *args = engine->nil;
	  TSCellHandle *prev_args;
	  g_object_ref(G_OBJECT(args));

	  isfile = file_name[1] == '1';
	  file_name = *argv++;
	  if (strcmp(file_name, "-") == 0)
	    fin = stdin;
	  else if (isfile)
	    fin = fopen(file_name, "r");

	  for(; *argv != NULL; argv++)
	    {
	      TSCellHandle *value;
	      prev_args = args;
	      value = ts_engine_mk_cell_string(engine, *argv);
	      args = ts_engine_mk_cell_cons(engine, value, args, 0);
	      g_object_unref(G_OBJECT(value));
	      g_object_unref(G_OBJECT(prev_args));
	    }
	  prev_args = args;
	  args = ts_engine_list_reverse_in_place(engine, engine->nil,
						 prev_args);
	  g_object_unref(G_OBJECT(prev_args));
	  ts_engine_define_global(engine, "*args*", args);
	  g_object_unref(G_OBJECT(args));
	}
      else
	fin = fopen(file_name, "r");

      if (isfile && fin == NULL)
	fprintf(stderr, "Could not open file %s\n", file_name);
      else
	{
	  if (isfile)
	    retcode = ts_engine_load_file(engine, fin);
	  else
	    retcode = ts_engine_load_string(engine, (char *)file_name);

	  if (!isfile || fin != stdin)
	    {
	      if (retcode != 0)
		fprintf(stderr, "Errors encountered reading %s\n", file_name);
	      if (isfile)
		fclose(fin);
	    }
	}

      file_name = *argv++;
    } while (file_name != NULL);

  if (argc == 1)
    retcode = ts_engine_load_file(engine, stdin);

  g_object_unref(G_OBJECT(engine));

  return retcode;
}
