/*
 * Copyright (c) 2003-2004 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: gziputils.h,v 1.5 2004/01/15 02:12:14 fuyu Exp $
 */

#ifndef _GZIPUTILS_H_
#define _GZIPUTILS_H_

#include "ochusha_async_buffer.h"

#include <zlib.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef struct _GzipBuffer GzipBuffer;


typedef enum
{
  GZIP_BUFFER_ERROR = -1,
  GZIP_BUFFER_INITIAL,
  GZIP_BUFFER_INFLATING,
  GZIP_BUFFER_INFLATION_DONE
} GzipBufferStatus;


GzipBuffer *gzip_buffer_new(OchushaAsyncBuffer *async_buffer);
void gzip_buffer_free(GzipBuffer *buffer);

void gzip_buffer_skip_gzip_header(GzipBuffer *buffer);
GzipBufferStatus gzip_buffer_append_data(GzipBuffer *buffer, const char *data,
					 unsigned int length);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _GZIPUTILS_H_ */
