/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: bbs_thread_ui.h,v 1.18 2003/12/29 09:42:42 fuyu Exp $
 */

#ifndef _BBSTHREAD_UI_H_
#define _BBSTHREAD_UI_H_

#include "config.h"

#include "ochusha_ui.h"
#include "ochusha_bbs_thread.h"
#include "ochusha_async_buffer.h"
#include "paned_notebook.h"
#include "threadlist_view.h"
#include "icon_label.h"

#ifdef __cplusplus
extern "C" {
#endif


typedef enum
{
  BBS_THREAD_FAVORITE	= 1 << 0,
  BBS_THREAD_HIDDEN	= 1 << 1,
  BBS_THREAD_NEW	= 1 << 2,
} ThreadlistEntryFlags;


/*
 * åɤGUIϢ
 */
/* ThreadlistInfoΥ֥饹Ū˻Ȥ */
typedef struct _BBSThreadGUIInfo
{
  /* ߤΥ */
  int view_rank;

  /* ߤΥ쥹ɽ */
  int num_shown;

  /* ɽ(ThreadlistEntryFlagsORȤä) */
  int view_flags;

  /* 򳫤ɽ쥹ֹ(0:ϴ) */
  int res_num;

  /* ᥤ򥹥ɽϤʸȤɽ뤫ɤ */
  ThreadViewMailtoMode show_mailto_mode;

  /*
   * Ƥ륹ΤΤBBSThreadView
   * last_read/next_markϤviewФΡ
   */
  GtkWidget *recent_view;

  /* ǽο쥹Ƭդޡ */
  GtkTextMark *last_read;

  /* ɽɽ֤դޡ */
  GtkTextMark *next_mark;

  /* ɸɽ֤ޤǳμ¤()뤵뤿idleؿ */
  guint scroller_id;

  /* ξ֤ɽstatusbarΥåID */
  guint message_id;

  /* ġΥ쥹GtkTextBuffer⥪եå */
  guint *offsets;
  guint offsets_length;

  gboolean rendering_done;

  /* ɽΥΥե(DATե)ΥХåե */
  OchushaAsyncBuffer *response_source_buffer;

  /* Ǹ˳ưʹߤΥ */
  gint view_ignored;

  /* 񤭹ѥ */
  GtkWidget *write_dialog;

  /* Ǹν񤭹߻̾ */
  gchar *last_name;

  /* Ǹν񤭹߻Υᥤ */
  gchar *last_mail;

  /* ܡ */
  gboolean thread_local_a_bone;

  gboolean a_bone_by_name;
  gchar *a_bone_by_name_pattern;

  gboolean a_bone_by_id;
  gchar *a_bone_by_id_pattern;

  gboolean a_bone_by_content;
  gchar *a_bone_by_content_pattern;

  guint bookmark_response_number;
  GtkWidget *bookmark;
} BBSThreadGUIInfo;


void prepare_thread_ui_initialization(OchushaApplication *application);
void initialize_thread_ui(OchushaApplication *application);
BBSThreadGUIInfo * ensure_bbs_thread_info(OchushaBBSThread *thread);
void specify_thread_view_point(OchushaBBSThread *thread,
			       PanedNotebook *board_view, int res_num);
GtkWidget *open_bbs_thread(OchushaApplication *application,
			   OchushaBBSThread *thread, IconLabel *tab_label);

void refresh_thread(OchushaApplication *application, GtkWidget *widget,
		    OchushaBBSThread *thread, IconLabel *tab_label);
void go_to_the_first_response(GtkWidget *widget, OchushaBBSThread *thread);
void go_to_the_last_response(GtkWidget *widget, OchushaBBSThread *thread);
void jump_to_bookmark(GtkWidget *widget, OchushaBBSThread *thread);

void select_thread_view_font(OchushaApplication *application);
void set_thread_view_font(const char *font_name);
void reset_thread_view_font();
void preview_thread_view_font(const char *font_name);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _BBSTHREAD_UI_H_ */
