/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: threadlist_view.h,v 1.12 2003/11/26 10:04:16 fuyu Exp $
 */

#ifndef _THREADLIST_VIEW_H_
#define _THREADLIST_VIEW_H_

#include "ochusha.h"

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif


#define THREADLIST_VIEW_TYPE			(threadlist_view_get_type())
#define THREADLIST_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), THREADLIST_VIEW_TYPE, ThreadlistView))
#define THREADLIST_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), THREADLIST_VIEW_TYPE, ThreadlistViewClass))
#define IS_THREADLIST_VIEW(obj)			(G_TYPE_CHECK_INSTANCE_TYPE((obj), THREADLIST_VIEW_TYPE))
#define IS_THREADLIST_VIEW_CLASS(klass)		(G_TYPE_CHECK_CLASS_TYPE((klass), THREADLIST_VIEW_TYPE))
#define THREADLIST_VIEW_GET_CLASS(obj)		(G_TYPE_INSTANCE_GET_CLASS((obj), THREADLIST_VIEW_TYPE, ThreadlistViewClass))


typedef struct _ThreadlistView ThreadlistView;
typedef struct _ThreadlistViewClass ThreadlistViewClass;

typedef struct _ThreadlistInfo ThreadlistInfo;


typedef enum {
  THREADLIST_SEARCH_DIRECTION_BACKWARD,
  THREADLIST_SEARCH_DIRECTION_FORWARD
} ThreadlistSearchDirection;


typedef enum {
  THREADLIST_SEARCH_ACTION_FORWARD,
  THREADLIST_SEARCH_ACTION_BACKWARD,
  THREADLIST_SEARCH_ACTION_REGEXP_FORWARD,
  THREADLIST_SEARCH_ACTION_REGEXP_BACKWARD,
  THREADLIST_SEARCH_ACTION_TERMINATE
} ThreadlistSearchAction;


struct _ThreadlistView
{
  GtkTreeView view;

  GtkTreeModel *model;

  GtkTreeViewColumn *rank_column;
  GtkTreeViewColumn *mark_column;
  GtkTreeViewColumn *title_column;
  GtkTreeViewColumn *n_res_column;
  GtkTreeViewColumn *n_read_column;
  GtkTreeViewColumn *n_unread_column;
  GtkTreeViewColumn *rank_diff_column;
  GtkTreeViewColumn *last_modified_column;

  GtkTreeSelection *selection;


  /* Ϣ */
  gboolean (*title_match_func)(const gchar *title, gpointer search_data);
  gint last_search_position;
  GtkTreePath *last_path;

  gint last_rank_diff;

  OchushaBBSThread *recently_pointed_thread;

  guint view_is_initialized	: 1;
  guint model_is_opened		: 1;
  guint use_native_search	: 1;
  guint being_searched		: 1;
};


struct _ThreadlistViewClass
{
  GtkTreeViewClass parent_class;

  void (*open_thread_view)(ThreadlistView *threadlist_view,
			   OchushaBBSThread *thread,
			   gboolean in_tab, gboolean with_browser);

  void (*thread_mouse_over)(ThreadlistView *threadlist_view,
			    OchushaBBSThread *thread);
  void (*thread_mouse_out)(ThreadlistView *threadlist_view,
			   OchushaBBSThread *thread);

  void (*toggle_mark)(ThreadlistView *threadlist_view,
		      OchushaBBSThread *thread);
  void (*toggle_hide)(ThreadlistView *threadlist_view,
		      OchushaBBSThread *thread);
  void (*mark_thread)(ThreadlistView *threadlist_view,
		      OchushaBBSThread *thread, gboolean do_mark);
  void (*reset_thread)(ThreadlistView *threadlist_view,
		       OchushaBBSThread *thread);
  void (*copy_thread_url)(ThreadlistView *threadlist_view,
			  OchushaBBSThread *thread);
  gboolean (*advance_view)(ThreadlistView *threadlist_view,
			   OchushaBBSThread *thread);
  gboolean (*back_view)(ThreadlistView *threadlist_view,
			OchushaBBSThread *thread);

  gboolean (*interactive_search)(ThreadlistView *threadlist_view,
				 ThreadlistSearchAction search_action);

  void (*do_on_selection)(ThreadlistView *threadlist_view, gint what_to_do);
  void (*do_on_thread_at_cursor)(ThreadlistView *threadlist_view,
				 gint what_to_do);
};


/*
 * ˤ륨ȥθɤѥ᡼
 */
typedef enum
{
  THREADLIST_ENTRY_FLAG_MARK = 		1 << 0,		/* ˥å */
  THREADLIST_ENTRY_FLAG_STRIKE = 	1 << 1,		/* ä */
} ThreadlistEntryVisualFlags;


typedef struct _ThreadlistEntryVisualParameter
{
  guint flags			: 2;	/* ThreadlistEntryVisualFlagsOR */

  guint foreground_color	: 4;	/* 16¿뤯餤 */
  guint background_color	: 4;	/* 16¿뤯餤 */

  guint reserved		: 22;
} ThreadlistEntryVisualParameter;


#define THREADLIST_ENTRY_VISUAL_FLAGS_WIDTH		2
#define THREADLIST_ENTRY_VISUAL_FOREGROUND_COLOR_WIDTH	4
#define THREADLIST_ENTRY_VISUAL_BACKGROUND_COLOR_WIDTH	4


/*
 * ʲϤäỌ̇̄Τ̾ˤ٤桼ǽˤ뤳Ȥ
 * ͤʤ顢ϤΥåȤGUIԤ¦Ƿ
 * ٤
 *
 * ġĤȸ櫓ǰŪȤȤˤƤ
 */
typedef enum
{
  LIST_ENTRY_FOREGROUND_COLOR_NORMAL = 0,
  LIST_ENTRY_FOREGROUND_COLOR_BLUE = 1,
  LIST_ENTRY_FOREGROUND_COLOR_RED = 2,
  LIST_ENTRY_FOREGROUND_COLOR_GREEN = 3,
  LIST_ENTRY_FOREGROUND_COLOR_GRAY50 = 4,
  LIST_ENTRY_FOREGROUND_COLOR_GRAY75 = 5,
} ThreadlistEntryForegroundColor;


typedef enum
{
  LIST_ENTRY_BACKGROUND_COLOR_NORMAL = 0,
  LIST_ENTRY_BACKGROUND_COLOR_LAVENDER = 1,
  LIST_ENTRY_BACKGROUND_COLOR_PINK = 2,
  LIST_ENTRY_BACKGROUND_COLOR_DARK_SEA_GREEN1 = 3,
  LIST_ENTRY_BACKGROUND_COLOR_GRAY75 = 4,
  LIST_ENTRY_BACKGROUND_COLOR_GRAY90 = 5,
} ThreadlistEntryBackgroundColor;


GType threadlist_view_get_type(void);
GtkWidget *threadlist_view_new(void);

void threadlist_view_append_rank(ThreadlistView *view);
void threadlist_view_append_mark(ThreadlistView *view);
void threadlist_view_append_title(ThreadlistView *view);
void threadlist_view_append_number_of_responses(ThreadlistView *view);
void threadlist_view_append_number_of_responses_read(ThreadlistView *view);
void threadlist_view_append_number_of_responses_unread(ThreadlistView *view);
void threadlist_view_append_rank_difference(ThreadlistView *view);
void threadlist_view_append_last_modified(ThreadlistView *view);

void threadlist_view_initialize_default_view(ThreadlistView *view);

gboolean threadlist_view_open(ThreadlistView *view);
void threadlist_view_close(ThreadlistView *view,
			   OchushaBBSThread *last_thread);
void threadlist_view_append_thread(ThreadlistView *view,
				   OchushaBBSThread *thread,
				   gint last_rank, gint new_rank);
void threadlist_view_update_thread(ThreadlistView *view,
				   OchushaBBSThread *thread);
void threadlist_view_update_thread_visual(ThreadlistView *view,
				OchushaBBSThread *thread,
				ThreadlistEntryVisualParameter *parameter);

void threadlist_view_scroll_to_thread(ThreadlistView *view,
				      OchushaBBSThread *thread);

void threadlist_view_set_enable_native_search(ThreadlistView *view,
					      gboolean enable);
gboolean threadlist_view_get_enable_native_search(ThreadlistView *view);

gboolean threadlist_view_start_interactive_search(ThreadlistView *view);

typedef gboolean (ThreadlistViewTitleMatchFunc)(const gchar *title,
						gpointer search_data);

void threadlist_view_set_title_match_func(ThreadlistView *view,
					  ThreadlistViewTitleMatchFunc *func);
ThreadlistViewTitleMatchFunc *threadlist_view_get_title_match_func(
							ThreadlistView *view);
void threadlist_view_set_being_searched(ThreadlistView *view, gboolean being);
gboolean threadlist_view_find_next(ThreadlistView *view,
				   ThreadlistSearchDirection direction,
				   gboolean enable_wrap,
				   gboolean include_current_pos,
				   gpointer search_data);
#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _THREADLIST_VIEW_H_ */
