/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_board_2ch.h,v 1.4 2003/11/18 21:02:05 fuyu Exp $
 */

#ifndef _OCHUSHA_BOARD_2CH_H_
#define _OCHUSHA_BOARD_2CH_H_

#include "ochusha_bulletin_board.h"

#include <glib-object.h>
#include <glib.h>

#ifdef __cplusplus
extern "C" {
#endif

#define OCHUSHA_TYPE_BOARD_2CH			(ochusha_board_2ch_get_type())
#define OCHUSHA_BOARD_2CH(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), OCHUSHA_TYPE_BOARD_2CH, OchushaBoard2ch))
#define OCHUSHA_BOARD_2CH_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), OCHUSHA_TYPE_BOARD_2CH, OchushaBoard2chClass))
#define OCHUSHA_IS_BOARD_2CH(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), OCHUSHA_TYPE_BOARD_2CH))
#define OCHUSHA_IS_BOARD_2CH_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), OCHUSHA_TYPE_BOARD_2CH))
#define OCHUSHA_BOARD_2CH_GET_CLASS(obj) 	(G_TYPE_INSTANCE_GET_CLASS((obj), OCHUSHA_TYPE_BOARD_2CH, OchushaBoard2chClass))


typedef struct _OchushaBoard2ch OchushaBoard2ch;
typedef struct _OchushaBoard2chClass OchushaBoard2chClass;


struct _OchushaBoard2ch
{
  OchushaBulletinBoard parent_object;

  /* parent_object.base_url */
  char *read_cgi_url;		/* 㤨 "http://pc.2ch.net/read.cgi*/

  char *last_modified;	/* Ĥsubject.txtɤ߹߻Last-Modifiedإå */
  char *cookie;		/* Ǹ˼cookie */
};


struct _OchushaBoard2chClass
{
  OchushaBulletinBoardClass parent_class;

  /* virtual function table */
  char *(*get_read_cgi_url)(OchushaBoard2ch *board);
};


GType ochusha_board_2ch_get_type(void);
OchushaBulletinBoard *ochusha_board_2ch_new(const gchar *name,
					    const gchar *url);

const char *ochusha_board_2ch_get_read_cgi_url(OchushaBoard2ch *board);
const char *ochusha_board_2ch_get_cookie(OchushaBoard2ch *board);
void ochusha_board_2ch_set_cookie(OchushaBoard2ch *board, const char *cookie);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_BOARD_2CH_H_ */
