/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: boardlist_ui.h,v 1.8 2003/06/20 18:14:40 fuyu Exp $
 */

#ifndef _BOARDLIST_UI_H_
#define _BOARDLIST_UI_H_

#include "ochusha_bbs_thread.h"
#include "ochusha_board_category.h"

#include "ochusha_ui.h"

#include "boardlist_view.h"

#ifdef __cplusplus
extern "C" {
#endif

void prepare_boardlist_ui_initialization(OchushaApplication *application);
void initialize_boardlist(OchushaApplication *application);
void refresh_boardlist(OchushaApplication *application);
void redraw_boardlist(OchushaApplication *appliction);
void finalize_boardlist(OchushaApplication *application);

void update_threadlist_entry(OchushaApplication *application,
			     OchushaBBSThread *thread);

void open_current_board_properties(OchushaApplication *application);

void refresh_current_threadlist(OchushaApplication *application);
void refresh_current_threadlist_all(OchushaApplication *application);
void redraw_current_threadlist_all(OchushaApplication *application);
void fix_filter_button_state(OchushaApplication *application);

void advance_threadlist_search(OchushaApplication *application,
			       ThreadlistView *view,
			       ThreadlistSearchAction search_action);
void terminate_threadlist_search(OchushaApplication *application,
				 ThreadlistView *view);
void start_current_threadlist_search(OchushaApplication *application);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _BOARDLIST_UI_H_ */
