/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: ochusha_bbs_thread.h,v 1.3 2003/05/15 19:55:44 fuyu Exp $
 */

#ifndef _OCHUSHA_BBS_THREAD_H_
#define _OCHUSHA_BBS_THREAD_H_

#include "ochusha_bulletin_board.h"
#include <glib-object.h>
#include <glib.h>


#ifdef __cplusplus
extern "C" {
#endif

#define OCHUSHA_TYPE_BBS_THREAD			(ochusha_bbs_thread_get_type())
#define OCHUSHA_BBS_THREAD(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), OCHUSHA_TYPE_BBS_THREAD, OchushaBBSThread))
#define OCHUSHA_BBS_THREAD_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), OCHUSHA_TYPE_BBS_THREAD, OchushaBBSThreadClass))
#define OCHUSHA_IS_BBS_THREAD(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), OCHUSHA_TYPE_BBS_THREAD))
#define OCHUSHA_IS_BBS_THREAD_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), OCHUSHA_TYPE_BBS_THREAD))
#define OCHUSHA_BBS_THREAD_GET_CLASS(obj) 	(G_TYPE_INSTANCE_GET_CLASS((obj), OCHUSHA_TYPE_BBS_THREAD, OchushaBBSThreadClass))


typedef struct _OchushaBBSResponse OchushaBBSResponse;
typedef gboolean StartThreadCallback(OchushaBBSThread *thread,
				     const char *title,
				     gpointer callback_data);
typedef gboolean EachResponseCallback(OchushaBBSThread *thread, int number,
				      const OchushaBBSResponse *response,
				      gpointer callback_data);
typedef gboolean EndThreadCallback(OchushaBBSThread *thread, gboolean finished,
				   gpointer callback_data);


struct _OchushaBBSThread
{
  GObject parent_object;

  OchushaBulletinBoard *board;

  char *id;	      /* 㤨DATե̾ */
  gchar *title;       /* "顪 GTK+ȤäLinuxǤ塼" */

  /* оΥ쥹(㤨subject.txt) */
  int number_of_responses_on_server;

  /* ɥ쥹(ɤ߹쥹) */
  int number_of_responses_read;


  /* Ĥ˴ؤäȤ(OchushaBBSThreadStateORȤä) */
  int flags;	/* XXX: ΤȤ̤ */
};


struct _OchushaBBSThreadClass
{
  GObjectClass parent_class;

  /* signals */
  void (*read_threadlist_element)(OchushaBBSThread *thread,
				  GHashTable *thread_attributes);
  void (*write_threadlist_element)(OchushaBBSThread *thread,
				   FILE *threadlist_xml);

  /* virtual function table */
  const char *(*get_response_character_encoding)(OchushaBBSThread *thread);
  OchushaAsyncBuffer *(*get_responses_source)(OchushaBBSThread *thread,
					      OchushaConfig *conf,
					      const char *last_modified,
					      OchushaCacheMode mode,
					      OchushaNetworkCallbacks *cb,
					      gpointer callback_data);
  gboolean (*parse_responses)(OchushaBBSThread *thread,
			      OchushaAsyncBuffer *buffer,
			      int start, int number,
			      StartThreadCallback *start_thread_callback,
			      EachResponseCallback *each_response_callback,
			      EndThreadCallback *end_thread_callback,
			      gpointer callback_data);
  const char *(*get_thread_url)(OchushaBBSThread *thread);
  gboolean (*check_url)(OchushaBBSThread *thread, const char *url,
			unsigned int *from_p, unsigned int *to_p);
};


struct _OchushaBBSResponse
{
  const char *name;
  const char *mailto;
  const char *date_id;
  const char *content;
};


typedef enum
{
  OCHUSHA_BBS_THREAD_DAT_DROPPED = 1 << 0,
} OchushaBBSThreadState;


GType ochusha_bbs_thread_get_type(void);
OchushaBBSThread *ochusha_bbs_thread_new(OchushaBulletinBoard *board,
					 const char *thread_id,
					 const gchar *title);

void ochusha_bbs_thread_set_board(OchushaBBSThread *thread,
				  OchushaBulletinBoard *board);
OchushaBulletinBoard *ochusha_bbs_thread_get_board(OchushaBBSThread *thread);

void ochusha_bbs_thread_set_id(OchushaBBSThread *thread, const char *id);
const char *ochusha_bbs_thread_get_id(OchushaBBSThread *thread);

void ochusha_bbs_thread_set_title(OchushaBBSThread *thread,
				  const gchar *title);
const gchar *ochusha_bbs_thread_get_title(OchushaBBSThread *thread);

int ochusha_bbs_thread_get_number_of_responses_on_server(OchushaBBSThread *thread);
int ochusha_bbs_thread_get_number_of_responses_read(OchushaBBSThread *thread);

const char *ochusha_bbs_thread_get_thread_url(OchushaBBSThread *thread);

gboolean ochusha_bbs_thread_check_url(OchushaBBSThread *thread,
				      const char *url, unsigned int *from_p,
				      unsigned int *end_p);

const char *ochusha_bbs_thread_get_response_character_encoding(
						OchushaBBSThread *thread);
OchushaAsyncBuffer *ochusha_bbs_thread_get_responses_source(
						OchushaBBSThread *thread,
						OchushaConfig *conf,
						const char *last_modified,
						OchushaCacheMode mode,
						OchushaNetworkCallbacks *cb,
						gpointer callback_data);
gboolean ochusha_bbs_thread_parse_responses(OchushaBBSThread *thread,
					    OchushaAsyncBuffer *buffer,
					    int start, int number,
					    StartThreadCallback *start_cb,
					    EachResponseCallback *response_cb,
					    EndThreadCallback *end_cb,
					    gpointer callback_data);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _OCHUSHA_BBS_THREAD_H_ */
