/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: bbs_thread_ui.h,v 1.3 2003/05/15 19:55:43 fuyu Exp $
 */

#ifndef _BBSTHREAD_UI_H_
#define _BBSTHREAD_UI_H_

#include "ochusha_bbs_thread.h"
#include "ochusha_async_buffer.h"
#include "threadlist_view.h"
#include "icon_label.h"

#ifdef __cplusplus
extern "C" {
#endif


typedef enum
{
  BBS_THREAD_FAVORITE	= 1 << 0,
  BBS_THREAD_HIDDEN	= 1 << 1,
  BBS_THREAD_NEW	= 1 << 2,
} ThreadlistEntryFlags;


/*
 * åɤGUIϢ
 */
/* ThreadlistInfoΥ֥饹Ū˻Ȥ */
typedef struct _BBSThreadGUIInfo
{
  /* ߤΥ */
  int view_rank;

  /* ɽ(ThreadlistEntryFlagsORȤä) */
  int view_flags;

  /* ǽο쥹Ƭդޡ */
  GtkTextMark *last_read;

  /* ɽɽ֤դޡ */
  GtkTextMark *next_mark;

  /* ġΥ쥹GtkTextBuffer⥪եå */
  gint *offsets;

  gboolean rendering_done;

  /* ɽDATեΥХåե */
  OchushaAsyncBuffer *dat_buffer;

  char *last_modified;

  /* Ǹ˳ưʹߤΥ */
  gint view_ignored;
} BBSThreadGUIInfo;


#if 0
/* ThreadlistEntryStateĥƻȤ */
typedef enum
{
  BBS_THREAD_STARTUP = 1 << 2,
} ThreadlistEntryState;
#endif


void prepare_thread_ui_initialization(OchushaApplication *application);
void initialize_thread_ui(OchushaApplication *application);
BBSThreadGUIInfo * ensure_bbs_thread_info(OchushaBBSThread *thread);
GtkWidget *open_bbs_thread(OchushaApplication *application,
			   OchushaBBSThread *thread, IconLabel *tab_label);

void refresh_thread(OchushaApplication *application, GtkWidget *widget,
		    OchushaBBSThread *thread, IconLabel *tab_label);
void go_to_the_first_response(GtkWidget *widget, OchushaBBSThread *thread);
void go_to_the_last_response(GtkWidget *widget, OchushaBBSThread *thread);
void jump_to_new_comer_response(GtkWidget *widget, OchushaBBSThread *thread);


#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _BBSTHREAD_UI_H_ */
