/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: utils.h,v 1.1.1.1 2003/05/10 16:34:28 fuyu Exp $
 */

#ifndef _UTILS_H_
#define _UTILS_H_

#include <glib.h>
#include <iconv.h>

#ifdef __cplusplus
extern "C" {
#endif

#ifndef OCHUSHA_UTILS_IMPLEMENTATION
extern iconv_t utf8_to_native;
#endif

/*
 * utilityؿʤ
 */
void initialize_common_converters(void);
char *convert_string(iconv_t converter, const char *src, int length);

#if 1	/* to be obsoleted soon */
char *url_extract_http_server(const char *url);
char *url_extract_http_root_pathname(const char *url);
char *url_encode_string(const char *src);
char *url_decode_string(const char *src);
#endif

char *ochusha_utils_url_extract_http_server(const char *url);
char *ochusha_utils_url_extract_http_absolute_path(const char *url);
char *ochusha_utils_url_encode_string(const char *src);
char *ochusha_utils_url_decode_string(const char *src);

int mkdir_p(const char *path);


#ifdef __cplusplus
} // extern "C"
#endif

#endif
