/*
 * Copyright (c) 2003 The Ochusha Project.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $Id: bulletin_board_ui.h,v 1.1.1.1 2003/05/10 16:34:25 fuyu Exp $
 */

#ifndef _BULLETIN_BOARD_UI_H_
#define _BULLETIN_BOARD_UI_H_

#include "ochusha_async_buffer.h"

#include "ochusha.h"
#include "ochusha_ui.h"

#include "boardlist_view.h"
#include "icon_label.h"
#include "threadlist_filter.h"
#include "threadlist_view.h"

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif


/* BulletinBoardInfoΥ֥饹Ū˻Ȥ */
typedef struct _BulletinBoardGUIInfo
{
  BulletinBoardInfo info;

  OchushaAsyncBuffer *subject_txt_buffer;

  GtkWidget *properties_dialog;

  char *last_modified;

  ThreadlistFilter filter;

  gboolean enable_filter;
  volatile gboolean is_busy;
} BulletinBoardGUIInfo;


void initialize_board_ui(OchushaApplication *application);

BulletinBoardGUIInfo *ensure_bulletin_board_info(OchushaBulletinBoard *board);
GtkWidget *open_bulletin_board(OchushaApplication *application,
			       OchushaBulletinBoard *board,
			       IconLabel *tab_label);
void finalize_bulletin_board_view(OchushaBulletinBoard *board,
				  GtkWidget *widget);

void ochusha_open_thread(OchushaApplication *application,
			 OchushaBulletinBoard *board, OchushaBBSThread *thread,
			 char *dat_filename, int res_num, gboolean in_tab);

void refresh_threadlist_view(OchushaApplication *application,
			     OchushaBulletinBoard *board);
void redraw_threadlist_view(OchushaApplication *application,
			    OchushaBulletinBoard *board);
OchushaAsyncBuffer *snatch_subject_txt_buffer_for_board(OchushaBulletinBoard *board);
void update_threadlist_entry_style(OchushaApplication *application,
				   ThreadlistView *view,
				   OchushaBBSThread *thread);

void refresh_current_thread(OchushaApplication *application);
void jump_to_new_comer_response_of_current_thread(OchushaApplication *application);
void go_to_the_last_response_of_current_thread(OchushaApplication *application);
void go_to_the_first_response_of_current_thread(OchushaApplication *application);

#ifdef __cplusplus
} // extern "C"
#endif

#endif	/* _BULLETIN_BOARD_UI_H_ */
