/* mod_list_store.h
 * Copyright (C) 2000  Red Hat, Inc.,  Jonathan Blandford <jrb@redhat.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

/*
 * This is a modified version of GtkListStore from GTK+-2.2.4 by the
 * Ochusha Project.  See the AUTHORS file for a list of people on the
 * Ochusha Project.  See the ChangeLog files for a list of changes.
 * These files are distributed with ochusha at
 * http://ochusha.sourceforge.jp/.
 *
 * Since libmodifiedgtk2 only has limited set of modified widgets and
 * is intended to be used with original GTK+, I don't want to cause name
 * space conflictions with original widgets sets from GTK+.  Therefore,
 * ALL PUBLICLY AVAILABLE NAMES ARE RENAMED.
 *
 * $Id: mod_list_store.h,v 1.2 2004/02/05 00:43:54 fuyu Exp $
 */

#ifndef __MOD_LIST_STORE_H__
#define __MOD_LIST_STORE_H__

#include <gtk/gtk.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

#define MOD_TYPE_LIST_STORE	       (mod_list_store_get_type ())
#define MOD_LIST_STORE(obj)	       (G_TYPE_CHECK_INSTANCE_CAST ((obj), MOD_TYPE_LIST_STORE, ModListStore))
#define MOD_LIST_STORE_CLASS(klass)    (G_TYPE_CHECK_CLASS_CAST ((klass), MOD_TYPE_LIST_STORE, ModListStoreClass))
#define MOD_IS_LIST_STORE(obj)	       (G_TYPE_CHECK_INSTANCE_TYPE ((obj), MOD_TYPE_LIST_STORE))
#define MOD_IS_LIST_STORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), MOD_TYPE_LIST_STORE))
#define MOD_LIST_STORE_GET_CLASS(obj)  (G_TYPE_INSTANCE_GET_CLASS ((obj), MOD_TYPE_LIST_STORE, ModListStoreClass))

typedef struct _ModListStore       ModListStore;
typedef struct _ModListStoreClass  ModListStoreClass;

struct _ModListStore
{
  GObject parent;

  /*< private >*/
  gint stamp;
  gpointer root;
  gpointer tail;
  GList *sort_list;
  gint n_columns;
  gint sort_column_id;
  GtkSortType order;
  GType *column_headers;
  gint length;
  GtkTreeIterCompareFunc default_sort_func;
  gpointer default_sort_data;
  GtkDestroyNotify default_sort_destroy;
  guint columns_dirty : 1;
  guint sort_needed : 1;
  guint row_freezed : 1;
};

struct _ModListStoreClass
{
  GObjectClass parent_class;

  /* Padding for future expansion */
  void (*_gtk_reserved1) (void);
  void (*_gtk_reserved2) (void);
  void (*_gtk_reserved3) (void);
  void (*_gtk_reserved4) (void);
};


GType         mod_list_store_get_type         (void);
ModListStore *mod_list_store_new              (gint          n_columns,
					       ...);
ModListStore *mod_list_store_newv             (gint          n_columns,
					       GType        *types);
void          mod_list_store_set_column_types (ModListStore *list_store,
					       gint          n_columns,
					       GType        *types);

/* NOTE: use gtk_tree_model_get to get values from a ModListStore */

void          mod_list_store_set_value        (ModListStore *list_store,
					       GtkTreeIter  *iter,
					       gint          column,
					       GValue       *value);
void          mod_list_store_set              (ModListStore *list_store,
					       GtkTreeIter  *iter,
					       ...);
void          mod_list_store_set_valist       (ModListStore *list_store,
					       GtkTreeIter  *iter,
					       va_list       var_args);
gboolean      mod_list_store_remove           (ModListStore *list_store,
					       GtkTreeIter  *iter);
void          mod_list_store_insert           (ModListStore *list_store,
					       GtkTreeIter  *iter,
					       gint          position);
void          mod_list_store_insert_before    (ModListStore *list_store,
					       GtkTreeIter  *iter,
					       GtkTreeIter  *sibling);
void          mod_list_store_insert_after     (ModListStore *list_store,
					       GtkTreeIter  *iter,
					       GtkTreeIter  *sibling);
void          mod_list_store_prepend          (ModListStore *list_store,
					       GtkTreeIter  *iter);
void          mod_list_store_append           (ModListStore *list_store,
					       GtkTreeIter  *iter);
void          mod_list_store_clear            (ModListStore *list_store);
gboolean      mod_list_store_iter_is_valid    (ModListStore *list_store,
                                               GtkTreeIter  *iter);
void          mod_list_store_reorder          (ModListStore *store,
                                               gint         *new_order);
void          mod_list_store_swap             (ModListStore *store,
                                               GtkTreeIter  *a,
                                               GtkTreeIter  *b);
void          mod_list_store_move_after       (ModListStore *store,
                                               GtkTreeIter  *iter,
                                               GtkTreeIter  *position);
void          mod_list_store_move_before      (ModListStore *store,
                                               GtkTreeIter  *iter,
                                               GtkTreeIter  *position);
void          mod_list_store_freeze           (ModListStore *store);
void          mod_list_store_chew             (ModListStore *store);

#ifdef __cplusplus
}
#endif /* __cplusplus */


#endif /* __MOD_LIST_STORE_H__ */
