/*
 * Oaks
 * Copyright (c) 2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks.make;

import java.util.*;
import java.io.*;

class Line {
	private String	file;
	private	int	line;
	private String[]	data;
	private int out_cnt = 0;

	private static void cut( String s, ArrayList<String> str ) {
		char[]	ch = s.toCharArray();
		StringBuilder	buf = null;
		for ( char c : ch ) {
			if ( c == ';' || c == '{' || c == '}' ) {
				if ( buf != null )	str.add( buf.toString() );
				buf = null;
				str.add( new String( new char[]{ c } ) );
				continue;
			}
			if ( buf == null )	buf = new StringBuilder();
			buf = buf.append( c );
		}
		if ( buf != null )	str.add( buf.toString() );
	}

	Line(  String f, int l, String in ) {
		file = f;
		line = l;
		String[]	s = in.split( "\\p{Space}" );
		ArrayList<String>	str = new ArrayList<String>();
		for ( String n: s )	cut( n, str );
		data = str.toArray( new String[0] );
	}

	String toString( String msg ) {
		return String.format( "%s(%d): %s", file, line, msg );
	}

	String getWord() {
		if ( data.length <= out_cnt )	return null;
		out_cnt++;
		return data[out_cnt - 1];
	}

	String[] prefetch() {return data;}
}


class AllLine {
	private File mine;
	private String filename;
	private static ArrayList<File>	nest = new ArrayList<File>();
	private static ArrayList<Line>	line = new ArrayList<Line>();
	private int	cnt = 1;
	private int out_cnt = 0;
	private Line	last_line;

	private boolean cm_f = false;

	AllLine( String fn ) {
		this(null, fn);
	}
	private static void push(File f) {
		for(File test: nest) {
			if (f.equals(test)) {
				System.out.print( f.getAbsolutePath() );
				System.out.println( " 二重読み込みされています。" );
				System.exit( 1 );
			}
		}
		nest.add(f);
	}
	private static void pop() {
		nest.remove(nest.size() - 1);
	}
	private AllLine( File parent, String fn ) {
		mine = parent == null?	new File(parent, fn): new File(fn);
		fn = mine.getAbsolutePath();
		push( mine );
		System.out.print( "read:  " );
		System.out.println( fn );
		filename = fn;
		BufferedReader	br = null;
		try {
			br = new BufferedReader( new FileReader( fn ) );
			String	s = null;
			while( (s = br.readLine()) != null ) {
				add( s );
			}
		}
		catch( Exception e ) {
			System.out.println( "ファイル読み込みに失敗しました。" );
			System.exit( 1 );
		}
		finally {
			if ( br != null ) {
				try {
					br.close();
				}
				catch( Exception e ) {}
			}
		}
		pop();
	}

	String getWord() {
		if ( line.size() <= out_cnt )	return null;
		last_line = line.get( out_cnt );
		String	str = last_line.getWord();
		if ( str == null ) {
			out_cnt++;
			return getWord();
		}
		return str;
	}

	Line getLine() {
		return last_line;
	}

	private String cm_out( String s, int start ) {
		int	end = s.indexOf( "*/" );
		if ( end < start ) {
			cm_f = true;
			return s.substring( 0, start );
		}
		StringBuilder	buf = new StringBuilder();
		buf = buf.append( s.substring( 0, start ) );
		buf = buf.append( " " );
		end += 2;
		if ( s.length() > end ) {
			buf = buf.append( s.substring( end ) );
		}
		return fix( buf.toString() );
	}

	private String fix( String s ) {
		if ( cm_f ) {
			cm_f = false;
			int	end = s.indexOf( "*/" );
			if ( end == -1 )	return "";
			end += 2;
			if ( s.length() <= end )	return "";
			return fix( s.substring( end ) );
		}
		int[] start = new int[] {
			s.indexOf( "/*" ), s.indexOf( "//" )
		};
		if ( start[0] == -1 && start[1] == -1 )	return s;
		if ( start[0] == -1 )	return s.substring( 0, start[1] );
		if ( start[1] == -1 )	return cm_out( s, start[0] );
		if ( start[0] > start[1] )	return s.substring( 0, start[1] );
		return cm_out( s, start[0] );
	}

	private void add( String s ) {
		s = fix( s ).trim();
		if ( s.length() > 0 ) {
			boolean flag = true;
			Line l = new Line( filename, cnt, fix( s ) );
			String[] p = l.prefetch();
			if (p.length == 3) {
				if(p[0].equals("include") && p[2].equals(";")){
					flag = false;
					AllLine sub = new AllLine(mine, p[1]);
				}
			}
			if(flag) {
				line.add( l );
			}
		}
		cnt++;
	}

}






