/*
 * Oaks
 * Copyright (c) 2012-2014  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks.make;


import java.util.*;
import java.io.*;

class Farm {
	private static HashMap<String, Farm>	farm = new HashMap<String, Farm>();

	private static ArrayList<DefEnum>	en = null;
	private static ArrayList<DefTable>	table = null;
	private String pack;

	private Farm( String p ) {
		en = new ArrayList<DefEnum>();
		table = new ArrayList<DefTable>();
		pack = p;
		if ( p == null )	p = "";
		farm.put( p, this );
	}

	static Farm getFarm( String p ) {
		String	key = p;
		if ( key == null )	key = "";
		Farm	f = farm.get( key );
		if ( f == null )	f = new Farm( p );
		return f;
	}

	File getDir() {
		if ( pack != null ) {
			String[]	str = pack.split( "\\." );
			StringBuilder	buf = new StringBuilder();
			for ( int i = 0; i < str.length; i++ ) {
				buf = buf.append( str[i] );
				buf = buf.append( File.separator );
			}
			File	dir = new File( DAO.out_dir, buf.toString() );
			dir.mkdirs();
			if ( !dir.isDirectory() ) {
				System.out.print( dir.toString() );
				System.out.println( " が作成できませんでした。" );
				System.exit( 1 );
			}
			return dir;
		}
		return DAO.out_dir;
	}

	void add( DefEnum e ) {
		en.add( e );
	}

	void add( DefTable t ) {
		table.add( t );
	}

	static void output() {
		for ( String key: farm.keySet() ) {
			Farm	f = farm.get( key );
			f.my_output();
		}
	}

	private void my_output() {
		PrintWriter	pw = null;
		File	out = new File( getDir(), "Farm.java" );
		System.out.print( "write: " );
		System.out.println( out.toString() );
		try {
			pw = new PrintWriter( new BufferedWriter(
				new OutputStreamWriter(new FileOutputStream(out), DAO.Cmd.SRC_ENC.get())
			));
			pw.print( AtomTable.getHead() );
			pw.print( toString() );
		}
		catch( Exception e ) {
			System.out.println( "ファイル書き込みに失敗しました。" );
			System.exit( 1 );
		}
		finally {
			if ( pw != null ) {
				try {
					pw.close();
				}
				catch( Exception e ) {}
			}
		}
	}

	public String toString() {
		String	pk = "";
		if ( pack != null ) {
			StringBuilder	buf = new StringBuilder( "package " );
			buf = buf.append( pack ).append( ";" ).append( DAO.LF );
			pk = buf.toString();
		}
		StringBuilder	buf = new StringBuilder(
			DAO.toString(
				"// ", Version.getTitle(), "  ", new Date().toString(),
				 " output",DAO.LF,
				 pk, "import oaks.*;", DAO.LF,
				 "/** DAO定義管理。 */", DAO.LF,
				 "public class Farm{", DAO.LF,
				 "private Farm(){}", DAO.LF
			)
		);
		for ( DefEnum e: en ) {
			if ( e.getIO() == null )	continue;
			buf = buf.append( e.toString() );
		}
		for ( DefTable t: table ) {
			buf = buf.append( DAO.toString(
				"/** ", t.getName(), " インスタンス生成", DAO.LF,
				" * @return 新しいインスタンス。", DAO.LF,
				" */", DAO.LF,
				"public static ", t.getClassName(), " make", t.getClassName(),
				"(){return ", t.getClassName(), ".newInstance();}", DAO.LF
			) );
		}
		buf = buf.append( "}" );
		return buf.toString();
	}
}

