/*
 * Oaks
 * Copyright (c) 2012-2014  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks.make;

import oaks.*;
import java.util.*;

class NumberTest {
	static boolean isNumber( String io ) {
		Class<?>	cls = null;
		try {
			cls = Class.forName( io );
		}
		catch( ClassNotFoundException cnfe ) {
			return false;
		}
		return Number.class.isAssignableFrom( cls );
	}
}

class DefEnum {
	static final String STRING = "java.lang.String";

	private class Names {
		Line	line;
		String name;
		String val;
		Names( Line l, String n, String v ) {
			line = l;
			name = n;
			val = v;
		}
		boolean check( String io ) {
			if ( DefEnum.STRING.equals( io ) )	return true;
			if ( !NumberTest.isNumber( io ) )	return false;
			try {
				new java.math.BigInteger( val );
			}
			catch( NumberFormatException e ) {
				System.out.println( line.toString( val + " は整数表現ではありません。" ) );
				System.exit( 1 );
			}
			return true;
		}
	}
	private static HashMap<String, DefEnum>	def = new HashMap<String, DefEnum>();
	private static ArrayList<DefEnum> used = new ArrayList<DefEnum>();

	private Line	line;
	private String	class_name;
	private String	io_name = null;
	private HashMap<String,String>	mem_chk = new HashMap<String,String>();
	private HashMap<String,String>	val_chk = new HashMap<String,String>();
	private ArrayList<Names>	member = new ArrayList<Names>();

	DefEnum( Line l, String fldcls, String mycls ) {
		line = l;
		if ( mycls == null )	mycls = fldcls.toUpperCase( Locale.ENGLISH );
		class_name = mycls;
		if ( JavaDefine.isDefine( mycls, true ) ) {
			System.out.println( l.toString( mycls + " はクラス名に使用できません。" ) );
			System.exit( 1 );
		}
		if ( def.put( fldcls.toUpperCase( Locale.ENGLISH ), this ) != null ) {
			System.out.println( l.toString( fldcls + "には別のenumが割り当てられています。" ) );
			System.exit( 1 );
		}
		used.add( this );
	}

	static void lastSeek() {
		for ( DefEnum e: used ) {
			System.out.println( e.line.toString( "[警告]enum " + e.class_name +
				" は出力されませんでした。フィールドクラスの定義がありませんでした。"
			) );
		}
	}

	int getCount() {
		return member.size();
	}

	String getName() {
		return class_name;
	}

	String getIO() {
		return io_name;
	}

	void add( Line l, String n, String v ) {
		if ( mem_chk.put( n, n ) != null ) {
			System.out.println( l.toString( n + "が二重登録されています。" ) );
			System.exit( 1 );
		}
		if ( val_chk.put( v, v ) != null ) {
			System.out.println( l.toString( v + "が二重登録されています。" ) );
			System.exit( 1 );
		}
		member.add( new Names( l, n, v ) );
	}

	static DefEnum scan( DefField fld ) {
		String	fcls = fld.getClassName().toUpperCase( Locale.ENGLISH );
		DefEnum	de = def.get( fcls );
		if ( de == null )	return null;
		String	io = fld.getIO();
		if ( de.io_name == null ) {
			de.io_name = io;
			for ( Names n: de.member ) {
				if ( !n.check( io ) ) {
					System.out.println( fld.getLine().toString(
						fld.getFieldName() + " フィールドはenumに使用できない型(文字列、数値以外の型)です。"
					) );
					System.exit( 1 );
				}
			}
		}
		else if ( !de.io_name.equals( io ) ) {
			System.out.println( fld.getLine().toString(
				fcls + "クラスはenumを持ちますが、DBフィールドの型が統一されていません。"
			) );
			System.exit( 1 );
		}
		return de;
	}

	public String toString() {
		used.remove( this );
		StringBuilder	buf = new StringBuilder( DAO.toString(
			"public enum ", class_name, "{", DAO.LF
		) );
		int	cnt = member.size();
		for ( int i = 0; i < cnt; i++ ) {
			Names	n = member.get( i );
			buf = buf.append( "/** " ).append( n.val ).append( " */" ).append( DAO.LF );
			buf = buf.append( n.name ).append( "(" );
			if ( STRING.equals( io_name ) )	buf = buf.append( "\"" );
			else	buf = buf.append( DAO.toString(
				"new ", io_name, "(\""
			) );
			buf = buf.append( n.val );
			if ( STRING.equals( io_name ) )	buf = buf.append( "\"" );
			else	buf = buf.append( "\")" );
			buf = buf.append( ")" );
			if ( i == (cnt - 1) )	buf = buf.append( ";" );
			else	buf = buf.append( "," );
			buf = buf.append( DAO.LF );
		}
		buf = buf.append( DAO.toString(
			"private ", io_name, " data;", DAO.LF,
			"private ", class_name, "(", io_name, " v){data=v;}", DAO.LF,
			"/**", DAO.LF,
			" * DB値の取得。", DAO.LF,
			" * @return DB上での値。", DAO.LF,
			" */", DAO.LF,
			"public ", io_name, " get(){return data;}", DAO.LF,
			"/**", DAO.LF,
			" * DB値対応enumの取得。", DAO.LF,
			" * @param v DB上での値。", DAO.LF,
			" * @return 対応するenum。対応するものがなければnull。", DAO.LF,
			" */", DAO.LF,
			"public static ", class_name, " get(", io_name, " v){return value(v);}", DAO.LF,
			"static ", class_name, " value(Object v){", DAO.LF,
			"for(", class_name, " m: values()){", DAO.LF,
			"if (m.data.equals(v))return m;", DAO.LF,
			"}", DAO.LF,
			"return null;", DAO.LF,
			"}", DAO.LF,
			"}", DAO.LF
		) );
		return buf.toString();
	}
}

class DefField {
	private Line	line;
	private String real_name;
	private String class_name;
	private String io_name = null;
	private String[] len = new String[]{ "0", "0" };


	Line getLine() {
		return line;
	}

	DefField( Line l, String r, String c ) {
		real_name = r;
		if ( c == null )	c = r.toUpperCase( Locale.ENGLISH );
		class_name = c;
		if ( JavaDefine.isDefine( c, true ) ) {
			System.out.println( l.toString( c + " はクラス名に使用できません。" ) );
			System.exit( 1 );
		}
		line = l;
	}
	DefField( String r ) {
		this( null, r, null );
	}
	void setIO( String s, int p, int scl ) {
		io_name = s;
		len[0] = Integer.toString( p );
		len[1] = Integer.toString( scl );
	}
	String getIO() {
		return io_name;
	}
	String getFieldName() {
		return real_name;
	}
	String getClassName() {
		return class_name;
	}
	public String toString() {
		String	imp = "";
		String	ext = "Field";
		boolean	number_f = false;
		DefEnum	en = DefEnum.scan( this );
		if ( en != null )	io_name = DAO.toString( "Farm.", en.getName() );
		if ( DefEnum.STRING.equals( io_name ) ) {
			imp = " implements Where.Likeable";
		}
		else if ( NumberTest.isNumber( io_name ) ) {
			ext = "NumberField";
			number_f = true;
		}
		StringBuilder	buf = new StringBuilder(  DAO.toString(
			"/** ", real_name, " */", DAO.LF,
			"public static class ", class_name, " extends ", ext, "<", io_name, ">",
			imp, "{", DAO.LF,
			"private static final long serialVersionUID = 1;", DAO.LF,
			"private static final MetaData meta = new MetaData(",
				io_name, ".class,", len[0], ",", len[1], ");", DAO.LF
		) );
		buf = buf.append( DAO.toString(
			"static{init(", class_name, ".class,\"", real_name, "\");}", DAO.LF,
			"/**", DAO.LF,
			" * コンストラクタ。", DAO.LF,
			" */", DAO.LF,
			"private ", class_name, "(){super(\"", real_name, "\");}",DAO.LF,
			"/**", DAO.LF,
			" * コンストラクタ。", DAO.LF,
			" * @param v 初期値。", DAO.LF,
			" */", DAO.LF,
			"public ", class_name, "(", io_name, " v){this();set(v);}",DAO.LF,
			"/**", DAO.LF,
			" * コンストラクタ。", DAO.LF,
			" * @param g 集計関数。", DAO.LF,
			" * @param v 比較値。", DAO.LF,
			" */", DAO.LF,
			"public ", class_name, "(GRP g, ", io_name,
				" v){this();set(v);setGroup(g);}",DAO.LF,
			"/**", DAO.LF,
			" * メタデータの取得。", DAO.LF,
			" * @return メタデータ。", DAO.LF,
			" */", DAO.LF,
			"public MetaData getMetaData(){return meta;}", DAO.LF
		) );
		if ( number_f ) {
			buf = buf.append( DAO.toString(
				"/**", DAO.LF,
				" * コンストラクタ。", DAO.LF,
				" * @param v 初期値。10進数を表す文字列とみなします。", DAO.LF,
				" */", DAO.LF,
				"public ", class_name, "(String v)throws NumberFormatException{this();set(v);}",DAO.LF,
				"/**", DAO.LF,
				" * コンストラクタ。", DAO.LF,
				" * @param g 集計関数。", DAO.LF,
				" * @param v 比較値。10進数を表す文字列とみなします。", DAO.LF,
				" */", DAO.LF,
				"public ", class_name, "(GRP g, String v)throws NumberFormatException{this();set(v);setGroup(g);}",DAO.LF,
				"/**", DAO.LF,
				" * 文字列を数値に変換して設定します。", DAO.LF,
				" * @param v 値。10進数を表す文字列とみなします。", DAO.LF,
				" */", DAO.LF,
				"public void set(String v)throws NumberFormatException{set(new ", io_name, "(v));}", DAO.LF
			) );
		}
		if ( en != null ) {
			buf = buf.append( DAO.toString(
				"protected ", io_name, " convert(Object o){return ",
					io_name, ".value(o);}", DAO.LF,
				"protected Object toObject(", io_name, " v){return v==null?null:v.get();}", DAO.LF
			) );
		}
		buf = buf.append( "}").append( DAO.LF );
		return buf.toString();
	}
}

class DefTable {
	private Line	line;
	private String pack = null;
	private String real_name;
	private String class_name;
	private boolean view_f;
	private ArrayList<DefField>	field = new ArrayList<DefField>();

	Line getLine() {
		return line;
	}

	DefTable( Line l, String p, String r, String c, boolean v ) {
		real_name = r;
		if ( c == null )	c = real_name;
		class_name = c;
		if ( JavaDefine.isDefine( c, true ) ) {
			System.out.println( l.toString( c + " はクラス名に使用できません。" ) );
			System.exit( 1 );
		}
		if ( "Farm".equals( c ) ) {
			System.out.println( l.toString( "Farm はクラス名に使用できません。" ) );
			System.exit( 1 );
		}
		view_f = v;
		pack = p;
		line = l;
	}
	void add( DefField f ) {
		field.add( f );
	}
	String getName() {
		return real_name;
	}
	String getClassName() {
		return class_name;
	}

	public String toString() {
		String	pk = "";
		if ( pack != null ) {
			StringBuilder	buf = new StringBuilder( "package " );
			buf = buf.append( pack ).append( ";" ).append( DAO.LF );
			pk = buf.toString();
		}
		StringBuilder	buf = new StringBuilder(
			DAO.toString(
				"// ", Version.getTitle(), "  ", new Date().toString(),
				" output",DAO.LF,
				pk, "import oaks.*;", DAO.LF,
				"/** ", real_name, " */", DAO.LF,
				"public class ", class_name, " extends ",
				view_f?	"View<":	"Table<", class_name, ">{", DAO.LF,
				"private static final long serialVersionUID = 1;", DAO.LF,
				"protected View getInstance(){return new ", class_name, "();}", DAO.LF
			)
		);
		for ( DefField f: field ) {
			buf = buf.append( f.toString() );
		}

		buf = buf.append(
			DAO.toString( "/** コンストラクタ */", DAO.LF,
				"private ", class_name, "(){", DAO.LF,
				"super(\"", real_name, "\");", DAO.LF,
				"fields = new Field[]{", DAO.LF
			)
		);
		for ( DefField f: field ) {
			buf = buf.append(
				DAO.toString( "new ", f.getClassName(), "(),", DAO.LF )
			);
		}
		buf = buf.append(
			DAO.toString(
				"};", DAO.LF,
				"}", DAO.LF
			)
		);

		int	count = field.size();
		for ( int i = 0; i < count; i++ ) {
			DefField	f = field.get( i );
			buf = buf.append(
				DAO.toString(
					"/** ", f.getFieldName(), DAO.LF,
					" * @return ", f.getFieldName(), DAO.LF,
					" */", DAO.LF,
					"@SuppressWarnings(\"unchecked\")", DAO.LF,
					"public ", f.getClassName(), " get", f.getClassName(), "(){return (", f.getClassName(), ")fields[", Integer.toString( i ), "];}", DAO.LF
				)
			);
		}
		
		buf = buf.append(
			DAO.toString(
				"static{", DAO.LF,
				"init(new ", class_name, "());", DAO.LF,
				"}",DAO.LF,
				"@SuppressWarnings(\"unchecked\")", DAO.LF,
				"static ", class_name, " newInstance(){return (",
				class_name, ")newInstance(", class_name, ".class);}", DAO.LF,
				"}", DAO.LF
			)
		);
		return buf.toString();
	}
}







