/*
 * Oaks
 * Copyright (c) 2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks.analysis;

import java.io.*;


/**
 * SQL情報収集基底クラス。この派生クラスを作成して使用して下さい。<br>
 * 簡易ロギング機能も持ちます。
 */
public abstract class Collecter {
	private File[]	log = null;
	private int size;

	/**
	 * SQL情報受け取り。
	 * このメソッドは排他処理され、複数スレッドが同時に呼び出す事はありません。
	 * @param info SQL情報。
	 */
	public abstract void post( SqlInformation info );

	/**
	 * ロギング設定。
	 * @param filename ログファイル名。フルパス指定して下さい。
	 * @param maxsize 1ファイルのバイトサイズ上限。
	 * @param gn ファイル世代数。filename末尾に数字を付与したファイルを生成します。
	 */
	public void setLogProperty( String filename, int maxsize, int gn ) {
		log = new File[gn];
		size = maxsize;
		log[0] = new File( filename );
		for ( int i = 1; i < gn; i++ ) {
			log[i] = new File( filename + "." + Integer.toString( i ) );
		}
	}

	/**
	 * ログ出力。<br>
	 * {@link Collecter#setLogProperty(String,int,int)}
	 * が呼び出されていない場合、標準出力へ出力されます。<br>
	 * また、日時の付与やフォーマット等は行いません。
	 * 指定文字列の終端に改行コードが付与されます。
	 * OSのデフォルト文字コードが使用されます。
	 * @param str 出力文字列。
	 */
	protected void println( String str ) {
		if ( log == null ) {
			System.out.println( str );
			return;
		}
		synchronized( log ) {
			if ( log[0].isFile() ) {
				if ( log[0].length() > size ) {
					log[log.length - 1].delete();
					for ( int i = log.length - 1; i > 0; i-- ) {
						log[i - 1].renameTo( log[i] );
					}
				}
			}
			try {
				PrintStream	out = new PrintStream( new FileOutputStream( log[0], true ) );
				out.println( str );
			}
			catch( Exception e ) {
				e.printStackTrace();
			}
		}
	}
}



