/*
 * Oaks
 * Copyright (c) 2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks;
import oaks.analysis.*;
import java.util.*;

class CallCollect extends Thread {
	private Collecter c;
	private LinkedList<SqlInformation>	que = new LinkedList<SqlInformation>();

	CallCollect( Collecter obj ) {
		c = obj;
		setDaemon( true );
		start();
	}

	void put( SqlInformation info ) {
		synchronized( que ) {
			que.offer( info );
			que.notifyAll();
		}
	}

	public void run() {
		while( true ) {
			try {
				SqlInformation	info = null;
				synchronized( que ) {
					if ( que.size() < 1 ) {
						que.wait( 1000 );
						continue;
					}
					info = que.poll();
				}
				c.post( info );
			}
			catch( Throwable e ) {
				e.printStackTrace();
			}
		}
	}
}

