/*
 * Oaks
 * Copyright (c) 2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks;

import java.sql.*;
import java.util.*;

/**
 * テーブルを表します。<br>
 * 派生クラスには更新や参照等、テーブルに対するメソッドが準備されます。
 */
public abstract class Table<E extends View> extends View<E> {
	private static final long serialVersionUID = 1;

	private Table(){super();}

	/**
	 * コンストラクタ。
	 * @param n テーブル名。
	 */
	protected Table( String n ) {
		super( n );
	}

	/**
	 * insertの実行。
	 * @param db DB接続。
	 * @return 更新行数。
	 */
	public int insert( DB db ) throws DB.DBException {
		ArrayList<Object>	list = new ArrayList<Object>();
		Field[] fld = fields;
		StringBuilder	buf = new StringBuilder( "insert into " );
		buf = buf.append( getName() ).append( "(" );
		boolean	first_f = true;
		for ( int i = 0; i < fld.length; i++ ) {
			if ( fld[i].getObject() == Field.NO_CARE )	continue;
			if ( first_f )	first_f = false;
			else	buf = buf.append( "," );
			buf = buf.append( fld[i].getName() );
		}
		if ( first_f )	return 0;
		buf = buf.append( ")values(" );
		first_f = true;
		for ( int i = 0; i < fld.length; i++ ) {
			if ( fld[i].getObject() == Field.NO_CARE )	continue;
			if ( first_f )	first_f = false;
			else	buf = buf.append( "," );
			buf = buf.append( "?" );
			list.add( fld[i].getObject() );
		}
		buf = buf.append( ")" );
		String	sql = buf.toString();
		Object[]	obj = list.toArray( new Object[0] );
		return db.executeUpdate( sql, obj );
	}

	/**
	 * truncateの実行。
	 * @param db DB接続。
	 * @return 更新行数。
	 */
	public int truncate( DB db ) throws DB.DBException {
		StringBuilder	buf = new StringBuilder( "truncate table " );
		buf = buf.append( getName() );
		String	sql = buf.toString();
		return db.executeUpdate( sql );
	}

	/**
	 * deleteの実行。
	 * @param db DB接続。
	 * @param where 検索条件。条件が無い場合はnull。
	 * @return 更新行数。
	 */
	public int delete( DB db, Where where ) throws DB.DBException {
		StringBuilder	buf = new StringBuilder( "delete from " );
		buf = buf.append( getName() );
		if ( where != null ) {
			buf = buf.append( where.getString( true ) );
			Object[]	obj = where.getParam();
			return db.executeUpdate( buf.toString(), obj );
		}
		return db.executeUpdate( buf.toString() );
	}

	/**
	 * updateの実行。
	 * @param db DB接続。
	 * @param where 検索条件。条件が無い場合はnull。
	 * @return 更新行数。
	 */
	public int update( DB db, Where where ) throws DB.DBException {
		ArrayList<Object>	list = new ArrayList<Object>();
		StringBuilder	buf = new StringBuilder( "update " );
		buf = buf.append( getName() );
		Field[]	fld = fields;
		boolean	first_f = true;
		buf = buf.append( " set " );
		for ( int i = 0; i < fld.length; i++ ) {
			Object	obj = fld[i].getObject();
			if ( obj == Field.NO_CARE )	continue;
			if ( first_f )	first_f = false;
			else	buf = buf.append( "," );
			buf = buf.append( fld[i].getName() );
			buf = buf.append( "=" );
			if ( obj != null ) {
				buf = buf.append( "?" );
				list.add( obj );
			}
			else	buf = buf.append( "NULL" );
		}
		if ( first_f )	return 0;
		if ( where != null ) {
			buf = buf.append( where.getString( true ) );
			Object[]	w =  where.getParam();
			for ( int i = 0; i < w.length; i++ )	list.add( w[i] );
		}
		String	sql = buf.toString();
		Object[]	w = list.toArray( new Object[0] );
		return db.executeUpdate( sql, w );
	}

	/**
	 * select for updateの実行。
	 * @param db DB接続。
	 * @param where 検索条件。条件が無い場合はnull。
	 * @param order ソート指定。
	 */
	public SelectList<E> select4update( DB db, Where where, OrderBy ... order ) throws DB.DBException {
		StringBuilder	buf = new StringBuilder( makeSelect( where, null, null, order ) );
		buf = buf.append( " for update" );
		return select( db, buf.toString(), where, null );
	}
}

