/*
 * Oaks
 * Copyright (c) 2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks;

import java.util.*;
import java.sql.*;

/**
 * select順を表します。
 */
public class OrderBy {
	private boolean desc_f;
	private Class<? extends Field>	fld;
	private Field.GRP	grp = null;

	boolean isDesc() {
		return desc_f;
	}

	boolean isGroup() {
		return grp != null;
	}

	String getField() {
		return Field.getName( fld );
	}

	SelectItem toSelectItem() {
		return new SelectItem( fld, grp );
	}

	/**
	 * コンストラクタ。
	 * @param field ソート対象。
	 * @param desc	true:降順、false:昇順。
	 */
	public OrderBy( Class<? extends Field> field, boolean desc ) {
		fld = field;
		desc_f = desc;
	}

	/**
	 * コンストラクタ。昇順指定になります。
	 * @param field ソート対象。
	 */
	public OrderBy( Class<? extends Field> field ) {
		this( field, false );
	}

	/**
	 * コンストラクタ。
	 * @param field ソート対象。
	 * @param function 集計関数。
	 * @param desc	true:降順、false:昇順。
	 */
	public OrderBy( Class<? extends Field> field, Field.GRP function, boolean desc ) {
		this( field, desc );
		grp = function;
	}

	/**
	 * コンストラクタ。昇順指定になります。
	 * @param field ソート対象。
	 * @param function 集計関数。
	 */
	public OrderBy( Class<? extends Field> field, Field.GRP function ) {
		this( field, function, false );
	}
}

class SelectItem {
	private Class<? extends Field>	fld;
	private Field.GRP	grp;
	private String	key;

	SelectItem( Class<? extends Field> f, Field.GRP g ) {
		fld = f;
		grp = g;
		StringBuilder	buf = new StringBuilder( f.toString() );
		buf = buf.append( "<oaks>" );
		if ( g != null ) {
			buf = buf.append( g.toString() );
		}
		key = buf.toString();
	}

	public boolean equals( Object o ) {
		if ( !(o instanceof SelectItem) )	return false;
		SelectItem	s = (SelectItem)o;
		return key.equals( s.key );
	}

	public int hashCode() {
		return key.hashCode();
	}

	public String toString() {
		if ( grp != null )	return Field.toString( grp, fld );
		return Field.getName( fld );
	}

	void set( View v, Object o ) {
		Field[]	f = v.fields;
		for ( int i = 0; i < f.length; i++ ) {
			if ( f[i].getClass().equals( fld ) ) {
				f[i].setObject( grp, o );
				return;
			}
		}
	}
}

class SelectGroup {
	private ArrayList<SelectItem>	select = new ArrayList<SelectItem>();
	private HashMap<SelectItem, Integer>	no = new HashMap<SelectItem, Integer>();
	private ArrayList<OrderBy>		order = new ArrayList<OrderBy>();
	private ArrayList<Integer>		order_no = new ArrayList<Integer>();

	void set( View v, ResultSet rs ) throws SQLException {
		for( SelectItem si: no.keySet() ) {
			Object	obj = rs.getObject( no.get( si ) );
			if ( obj instanceof java.sql.Date ) {
				obj = rs.getDate( no.get( si ), DB.TIMEZONE );
			}
			else if ( obj instanceof java.sql.Time ) {
				obj = rs.getTime( no.get( si ), DB.TIMEZONE );
			}
			else if ( obj instanceof java.sql.Timestamp ) {
				obj = rs.getTimestamp( no.get( si ), DB.TIMEZONE );
			}
			si.set( v, obj );
		}
	}

	SelectGroup( Field[] f, GroupBy gb, OrderBy[] od ) throws DB.DBException {
		if ( od == null )	od = new OrderBy[0];
		int	cnt = 1;
		for ( int i = 0; i < f.length; i++ ) {
			if ( gb != null ) {
				Field.GRP[]	g = f[i].getGroup();
				if ( g != null && g.length != 0 ) {
					for ( int j = 0; j < g.length; j++ ) {
						SelectItem	item = new SelectItem( f[i].getClass(), g[j] );
						select.add( item );
						no.put( item, cnt );
						cnt++;
					}
				}
				if ( !gb.isHit( f[i] ) )	continue;
			}
			SelectItem	item = new SelectItem( f[i].getClass(), null );
			select.add( item );
			no.put( item, cnt );
			cnt++;
		}
		for ( int i = 0; i < od.length; i++ ) {
			order.add( od[i] );
			SelectItem	item = od[i].toSelectItem();
			Integer	seq = no.get( item );
			if ( seq == null ) {
				if ( !od[i].isGroup() )	throw new DB.DBException(
					String.format( "[order by]%s は group by 対象外なので指定できません。" )
				);
				select.add( item );
				no.put( item, cnt );
				seq = cnt;
				cnt++;
			}
			order_no.add( seq );
		}
	}

	String getSelect() {
		int	cnt = select.size();
		StringBuilder	buf = new StringBuilder( select.get( 0 ).toString() );
		for ( int i = 1; i < cnt; i++ ) {
			buf = buf.append( "," ).append( select.get( i ).toString() );
		}
		return buf.toString();
	}

	String getOrderBy() {
		int	cnt = order.size();
		if ( cnt == 0 )	return "";
		StringBuilder	buf = new StringBuilder();
		for ( int i = 0; i < cnt; i++ ) {
			if ( i == 0 )	buf = buf.append( " order by " );
			else	buf = buf.append( "," );
			buf = buf.append( order_no.get( i ).toString() );
			if ( order.get( i ).isDesc() )	buf = buf.append( " desc" );
		}
		return buf.toString();
	}
}




