/*
 * Oaks
 * Copyright (c) 2012  Akira Terasaki
 * このファイルは同梱されているLicense.txtに定めた条件に
 * 同意できる場合にのみ利用可能です。
 */
package oaks;

import java.util.*;


/**
 * 集計項目を表します。
 */
public class GroupBy {
	private ArrayList<Class<? extends Field>>	fld = new ArrayList<Class<? extends Field>>();

	GroupBy() {}

	/**
	 * コンストラクタ。
	 * @param field 集計対象。
	 * 指定したクラスが、Field派生クラスでない場合、無視されます。
	 */
	@SuppressWarnings("unchecked")
	public GroupBy( Class<?> ... field ) {
		if ( field == null )	return;
		for ( Class<?>	c: field ) {
			if ( Field.class.isAssignableFrom( c ) )	fld.add( (Class<? extends Field>)c );
		}
	}

	/**
	 * SQL文字列変換。
	 * @return Group by句文字列。
	 */
	public String toString() {
		int	size = fld.size();
		if ( size == 0 )	return null;
		StringBuilder buf = new StringBuilder( "group by " );
		for ( int i = 0; i < size; i++ ) {
			if ( i > 0 )	buf = buf.append( "," );
			buf = buf.append( Field.getName( fld.get( i ) ) );
		}
		return buf.toString();
	}

	boolean isHit( Field f ) {
		int	size = fld.size();
		if ( size == 0 )	return false;
		for ( int i = 0; i < size; i++ ) {
			if ( fld.get( i ).equals( f.getClass() ) )	return true;
		}
		return false;
	}
}




