// MultiCaptureTestDlg.cpp : t@C
//

#include "stdafx.h"
#include <assert.h>
#include "NyWin32Capture.h"
#include "MultiCaptureTest.h"
#include "MultiCaptureTestDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif


using namespace NyWin32Capture;

class CaptureItem
{
public:
	int tag;
	CaptureDevice* dev;
	BITMAPINFOHEADER dibheader;
	HWND hwnd;

	CaptureItem(int i_tag,CaptureDevice* i_dev,const BITMAPINFOHEADER& bmi,HWND i_hwnd)
	{
		this->tag=i_tag;
		this->dev=i_dev;
		this->dibheader=bmi;
		this->hwnd=i_hwnd;
	}
};
/*	AvP[VRg[
*/
class AppCtrl
{
public:
	CWnd* _wnd;
	CaptureDeviceList* devlist;
	std::vector<CaptureItem*> _item;
public:
	AppCtrl(CWnd* i_app_window)
	{
		CoInitialize(NULL);

		this->_wnd=i_app_window;
		CButton* bn=(CButton*)_wnd->GetDlgItem(ID_SWITCH);
		bn->SetWindowText(_T("start capture"));
		//JLv`foCX̃XgB
		devlist=new CaptureDeviceList();
		//Lv`foCX̃Xg1Ԗڂ̃J𓾂B
		int nod=this->devlist->getNumberOfDevice();
		if(nod<1){
			throw std::exception("This computer has not Capture device.");
		}
		//S̃J
		for(int i=0;i<nod;i++){
			CaptureDevice* d=devlist->getDevice(i);
			d->openDevice();
			//Lv`tH[}bgݒ
			BITMAPINFOHEADER b;
			SetupCaptureFormat(d,b);
			//R[obN[h̎Ɏg[U`lݒ
			CaptureItem* item=new CaptureItem(i,d,b,i_app_window->m_hWnd);
			this->_item.push_back(item);
			d->setUserValue(item);
		}
	}
	virtual ~AppCtrl()
	{
		for(int i=0;i<this->_item.size();i++){
			delete _item[i];
		}
		delete devlist;
		//JLv`foCX̃XgJ
		CoUninitialize();


	}
	//PԖڂ̃JQVGAŃLv`ł悤ɐݒ肷B
	bool SetupCaptureFormat(CaptureDevice* d,BITMAPINFOHEADER& bmiheader)
	{
		//tH[}bgXg𓾂B
		VideoFormatList lt;
		d->getVideoFormatList(lt);
		int nof=lt.getNumberOfFormat();
		if(nof<1){
			return "The device has not Video format.";
		}
		//C[W̃tH[}bgݒB̃^Cvuuids.hɏĂB
		const VideoFormat* vf=lt.getFormat(320,240,MEDIASUBTYPE_RGB24);
		if(vf==NULL){
			//JtH[}bgĂȂꍇ̓CeWFgڑB
			d->setVideoFormat(320,240,MEDIASUBTYPE_RGB24,30.0);
			VideoFormat::initBITMAPINFOHEADER(320,240,MEDIASUBTYPE_RGB24,bmiheader);
		}else{
			//JtH[}bgĂꍇ͂̂܂܎g
			d->setVideoFormat(*vf,30.0);
			bmiheader=*(vf->getBitmapInfoHeader());
		}
		//DIB邽߂Ƀwb_ۑĂ
		return true;
	}
	//data̓eEChEɕ`
	void DrawBitmap(void* data,int i)
	{
		//DIBBITMAPɕϊĕ`
		CDC* dc=this->_wnd->GetDC();
		CBitmap bmp;
		BITMAPINFO bmi;
		bmi.bmiHeader=this->_item[i]->dibheader;
		int x,y;
		x=(i%3)*320;
		y=(i/3)*240+32;
		int l=SetDIBitsToDevice(
			dc->m_hDC,x,y,320,240,
			0,0,0,240,data,&bmi,DIB_RGB_COLORS);
		this->_wnd->ReleaseDC(dc);
	}
	void Start(bool is_async)
	{
		for(int i=0;i<this->_item.size();i++){
			if(!is_async){
				this->_item[i]->dev->startCapture();	//擾̎Ȃ炱
			}else{
				this->_item[i]->dev->startCaptureCallback(AppCtrl::OnCaptureImage);		//񓯊擾̎Ȃ炱
			}
		}
	}
	void Stop()
	{
		for(int i=0;i<this->_item.size();i++){
			this->_item[i]->dev->stopCapture();
		}
	}
	static void OnCaptureImage(const CaptureDevice* i_sender,BYTE *pBuffer, long BufferLen)
	{
		//SendMessageŔ΂
		CaptureItem* inst=(CaptureItem*)(i_sender->getUserValue());
		DWORD ret;
		//GDIƓƂƂɃfbgbN\邩B
		if(SendMessageTimeout(inst->hwnd,WM_USER+39,inst->tag,(LPARAM)pBuffer,SMTO_ABORTIFHUNG,1000,&ret)==0){
			OutputDebugString(_T("Error on SendMessageTimeout"));
		}
	}
};


//NXJȂ̂ŃO[oϐɂĂ邯ǁAۂ
//eNX̃oɂ悢łB
AppCtrl* appctrl;




// CMultiCaptureTestDlg _CAO




CMultiCaptureTestDlg::CMultiCaptureTestDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CMultiCaptureTestDlg::IDD, pParent)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CMultiCaptureTestDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CMultiCaptureTestDlg, CDialog)
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	//}}AFX_MSG_MAP
	ON_BN_CLICKED(ID_SWITCH, &CMultiCaptureTestDlg::OnBnClickedSwitch)
	ON_WM_CLOSE()
	ON_WM_DESTROY()
	ON_WM_TIMER()
    ON_MESSAGE((WM_USER+39),CMultiCaptureTestDlg::OnASyncCapture)//Lv`
END_MESSAGE_MAP()


// CMultiCaptureTestDlg bZ[W nh

BOOL CMultiCaptureTestDlg::OnInitDialog()
{
	CDialog::OnInitDialog();

	// ̃_CAÕACRݒ肵܂BAvP[ṼC EBhE_CAOłȂꍇA
	//  Framework ́A̐ݒIɍs܂B
	SetIcon(m_hIcon, TRUE);			// 傫ACR̐ݒ
	SetIcon(m_hIcon, FALSE);		// ACR̐ݒ

	// TODO: ɒǉ܂B
	this->is_start=false;

	appctrl=new AppCtrl(this);

	return TRUE;  // tH[JXRg[ɐݒ肵ꍇATRUE Ԃ܂B
}

// _CAOɍŏ{^ǉꍇAACR`悷邽߂
//  ̃R[hKvłBhLg/r[ fg MFC AvP[V̏ꍇA
//  ́AFramework ɂĎIɐݒ肳܂B

void CMultiCaptureTestDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); // `̃foCX ReLXg

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		// NCAg̎lp`̈̒
		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// ACR̕`
		dc.DrawIcon(x, y, m_hIcon);

	}
	else
	{
		CDialog::OnPaint();
	}
}

// [U[ŏEBhEhbOĂƂɕ\J[\擾邽߂ɁA
//  VXe̊֐Ăяo܂B
HCURSOR CMultiCaptureTestDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}



//{^ꂽƂ
void CMultiCaptureTestDlg::OnBnClickedSwitch()
{
	//Lv`ONOFF̐؂ւ
	CButton* bn=(CButton*)this->GetDlgItem(ID_SWITCH);
	this->is_start=(!this->is_start);
	bn->SetWindowText(this->is_start?_T("stop capture"):_T("start capture"));
/*	//seXg
	if(this->is_start){
		appctrl->Start(false);
		this->SetTimer(123,100,NULL);
	}else{
		this->KillTimer(123);
		appctrl->Stop();
	}*/
	//񓯊Ȃ炱
	if(this->is_start){
		appctrl->Start(true);
	}else{
		appctrl->Stop();
	}
}

void CMultiCaptureTestDlg::OnClose()
{
	// TODO: ɃbZ[W nh R[hǉ邩ȀĂяo܂B

	CDialog::OnClose();
}

void CMultiCaptureTestDlg::OnDestroy()
{
	delete appctrl;
	CDialog::OnDestroy();
	// TODO: ɃbZ[W nh R[hǉ܂B
}

void CMultiCaptureTestDlg::OnTimer(UINT_PTR nIDEvent)
{
	CDialog::OnTimer(nIDEvent);
}
//SendMessageŔ΂bZ[W̎󂯌
LRESULT CMultiCaptureTestDlg::OnASyncCapture(WPARAM wParam, LPARAM lParam )
{
	//[64bit|C^Ƃ܂ȂH
	appctrl->DrawBitmap((void*)lParam,wParam);
	return 0;
}
