package jp.ac.kyutech.ai.ylab.shiva.nativecapable.plugin.exportwizard;

import java.net.MalformedURLException;
import java.net.URL;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.IDialogPage;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * The "New" wizard page allows setting the container for the new project as
 * well as the source folder.
 */

public class NativeCapableExportWizardConfigPage extends WizardPage {

	final String TYPE_FQCN = "jp.ac.kyutech.ai.ylab.shiva.utils.nativecapable.NativeCapableModule";

	final String TYPE_FQCN_OBJECT = "java.lang.Object";

	private Text appletWidthText;

	private Text appletHeightText;

	private Text jwsWidthText;

	private Text jwsHeightText;

	private Text codebaseText;

	private ISelection selection;

	/**
	 * Constructor for NyARToolkitProjectNewWizardPage.
	 * 
	 * @param pageName
	 */
	public NativeCapableExportWizardConfigPage(ISelection selection) {
		super("Config Page");
		setTitle("Native Capable Export Wizard");
		setDescription("This wizard exports native capables.");
		this.selection = selection;
	}

	/**
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);
		container.setLayout(new GridLayout(4, true));
		Label label;
		GridData gd;

		System.out.println("createControl");

		label = new Label(container, SWT.BOLD);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 4;
		gd.verticalIndent = 9;
		label.setLayoutData(gd);
		label.setText("Java Web Start:");

		label = new Label(container, SWT.NULL);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 1;
		gd.verticalIndent = 9;
		label.setLayoutData(gd);
		label.setText("Width:");

		jwsWidthText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.verticalIndent = 9;
		jwsWidthText.setLayoutData(gd);
		jwsWidthText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		label = new Label(container, SWT.NULL);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.verticalIndent = 9;
		label.setLayoutData(gd);
		label.setText("Height:");

		jwsHeightText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.verticalIndent = 9;
		jwsHeightText.setLayoutData(gd);
		jwsHeightText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		label = new Label(container, SWT.NULL);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.verticalIndent = 9;
		label.setLayoutData(gd);
		label.setText("&Codebase:");

		codebaseText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 3;
		gd.verticalAlignment = 4;
		gd.verticalIndent = 9;
		codebaseText.setLayoutData(gd);
		codebaseText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		Label sep = new Label(container, SWT.SEPARATOR | SWT.HORIZONTAL);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 4;
		gd.verticalIndent = 9;
		sep.setLayoutData(gd);

		label = new Label(container, SWT.BOLD);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 4;
		gd.verticalIndent = 9;
		label.setLayoutData(gd);
		label.setText("&Applet:");

		label = new Label(container, SWT.NULL);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.horizontalSpan = 1;
		gd.verticalIndent = 9;
		label.setLayoutData(gd);
		label.setText("Width:");

		appletWidthText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.verticalIndent = 9;
		appletWidthText.setLayoutData(gd);
		appletWidthText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});

		label = new Label(container, SWT.NULL);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.verticalIndent = 9;
		label.setLayoutData(gd);
		label.setText("Height:");

		appletHeightText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		gd.verticalIndent = 9;
		appletHeightText.setLayoutData(gd);
		appletHeightText.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				dialogChanged();
			}
		});
		initialize();
		dialogChanged();
		setControl(container);
	}

	private void setDefault() {

		jwsWidthText.setText("640");
		jwsHeightText.setText("480");
		codebaseText.setText("http://");
		appletWidthText.setText("320");
		appletHeightText.setText("240");

	}

	/**
	 * Tests if the current workbench selection is a suitable container to use.
	 */

	private void initialize() {
		if (selection != null && selection.isEmpty() == false
				&& selection instanceof IStructuredSelection) {
			IStructuredSelection ssel = (IStructuredSelection) selection;
			if (ssel.size() > 1)
				return;
			Object obj = ssel.getFirstElement();
			if (obj instanceof IResource) {
				IContainer container;
				if (obj instanceof IContainer) {
					container = (IContainer) obj;
				} else {
					container = ((IResource) obj).getParent();
				}
				appletWidthText.setText(container.getFullPath().toString());
			}
		}

		setDefault();

	}

	// /**
	// * Uses the standard container selection dialog to choose the new value
	// for
	// * the container field.
	// */
	//
	// private void handleBrowse() {
	// ContainerSelectionDialog dialog = new ContainerSelectionDialog(
	// getShell(), ResourcesPlugin.getWorkspace().getRoot(), false,
	// "Select new file container");
	// if (dialog.open() == ContainerSelectionDialog.OK) {
	// Object[] result = dialog.getResult();
	// if (result.length == 1) {
	// projectNameText.setText(((Path) result[0]).toString());
	// }
	// }
	// }

	/**
	 * Ensures that both text fields are set.
	 */
	private void dialogChanged() {
		String txt;
		int value = 0;

		// applet width
		txt = appletWidthText.getText();
		if (txt == null || txt.length() == 0) {
			updateStatus("Applet width must be specified.");
			return;
		}
		try {
			value = Integer.parseInt(txt);
		} catch (NumberFormatException nfEx) {
			updateStatus("Applet width must be positive integer.");
			return;
		}
		if (value <= 0) {
			updateStatus("Applet width must be positive integer.");
			return;
		}

		// applet height
		txt = appletHeightText.getText();
		if (txt == null || txt.length() == 0) {
			updateStatus("Applet height must be specified.");
			return;
		}
		try {
			value = Integer.parseInt(txt);
		} catch (NumberFormatException nfEx) {
			updateStatus("Applet height must be positive integer.");
			return;
		}
		if (value <= 0) {
			updateStatus("Applet height must be positive integer.");
			return;
		}

		// jws width
		txt = jwsWidthText.getText();
		if (txt == null || txt.length() == 0) {
			updateStatus("JWS width must be specified.");
			return;
		}
		try {
			value = Integer.parseInt(txt);
		} catch (NumberFormatException nfEx) {
			updateStatus("JWS width must be positive integer.");
			return;
		}
		if (value <= 0) {
			updateStatus("JWS width must be positive integer.");
			return;
		}

		// jws height
		txt = jwsHeightText.getText();
		if (txt == null || txt.length() == 0) {
			updateStatus("JWS height must be specified.");
			return;
		}
		try {
			value = Integer.parseInt(txt);
		} catch (NumberFormatException nfEx) {
			updateStatus("JWS height must be positive integer.");
			return;
		}
		if (value <= 0) {
			updateStatus("JWS height must be positive integer.");
			return;
		}

		// codebase
		txt = codebaseText.getText();
		if (txt == null || txt.length() == 0) {
			updateStatus("Codebase must be specified.");
			return;
		}
		try {
			new URL(txt);
		} catch (MalformedURLException e) {
			updateStatus("Codebase is not a valid URL.");
		}

		updateStatus(null);
	}

	private void updateStatus(String message) {
		setErrorMessage(message);
		setPageComplete(message == null);
	}

	public String getAppletWidth() {
		if (appletWidthText == null) {
			return "320";
		}
		return appletWidthText.getText();
	}

	public String getAppletHeight() {
		if (appletHeightText == null) {
			return "240";
		}
		return appletHeightText.getText();
	}

	public String getJwsWidth() {
		if (jwsWidthText == null) {
			return "640";
		}
		return jwsWidthText.getText();
	}

	public String getJwsHeight() {
		if (jwsHeightText == null) {
			return "480";
		}
		return jwsHeightText.getText();
	}

	public String getCodebase() {
		if (codebaseText == null) {
			return "http://";
		}
		return codebaseText.getText();
	}

	public void updateControl(boolean createApplet, boolean createJws) {

		if (jwsWidthText == null) {
			return;
		}

		jwsWidthText.setEnabled(createJws);
		jwsHeightText.setEnabled(createJws);
		codebaseText.setEnabled(createJws);
		appletWidthText.setEnabled(createApplet);
		appletHeightText.setEnabled(createApplet);
	}

}