/*
 * Decompiled with CFR 0.152.
 */
package jp.nyatla.nyartoolkit.core;

import jp.nyatla.nyartoolkit.NyARException;
import jp.nyatla.nyartoolkit.core.NyARColorPatt;
import jp.nyatla.nyartoolkit.core.NyARMarker;
import jp.nyatla.nyartoolkit.core.NyARMat;
import jp.nyatla.nyartoolkit.core.raster.NyARRaster;

public class NyARColorPatt_O2
implements NyARColorPatt {
    private static final int AR_PATT_SAMPLE_NUM = 64;
    private int[][][] extpat;
    private int width;
    private int height;
    private final NyARMat wk_get_cpara_a = new NyARMat(8, 8);
    private final NyARMat wk_get_cpara_b = new NyARMat(8, 1);
    private int[][][] wk_pickFromRaster_ext_pat2 = null;
    private final double[][] wk_pickFromRaster_world = new double[][]{{100.0, 100.0}, {110.0, 100.0}, {110.0, 110.0}, {100.0, 110.0}};
    private final double[][] wk_pickFromRaster_local = new double[2][4];
    private final int[] wk_pickFromRaster_rgb_tmp = new int[3];
    private final NyARMat wk_pickFromRaster_cpara = new NyARMat(8, 1);

    public NyARColorPatt_O2(int i_width, int i_height) {
        this.width = i_width;
        this.height = i_height;
        this.extpat = new int[i_height][i_width][3];
        this.wk_pickFromRaster_ext_pat2 = new int[i_height][i_width][3];
    }

    @Override
    public int[][][] getPatArray() {
        return this.extpat;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private boolean get_cpara(double[] vertex_0, double[] vertex_1, NyARMat o_para) throws NyARException {
        double[][] world = this.wk_pickFromRaster_world;
        NyARMat a = this.wk_get_cpara_a;
        double[][] a_array = a.getArray();
        NyARMat b = this.wk_get_cpara_b;
        double[][] b_array = b.getArray();
        for (int i = 0; i < 4; ++i) {
            double[] a_pt0 = a_array[i * 2];
            double[] a_pt1 = a_array[i * 2 + 1];
            double[] world_pti = world[i];
            a_pt0[0] = world_pti[0];
            a_pt0[1] = world_pti[1];
            a_pt0[2] = 1.0;
            a_pt0[3] = 0.0;
            a_pt0[4] = 0.0;
            a_pt0[5] = 0.0;
            a_pt0[6] = -world_pti[0] * vertex_0[i];
            a_pt0[7] = -world_pti[1] * vertex_0[i];
            a_pt1[0] = 0.0;
            a_pt1[1] = 0.0;
            a_pt1[2] = 0.0;
            a_pt1[3] = world_pti[0];
            a_pt1[4] = world_pti[1];
            a_pt1[5] = 1.0;
            a_pt1[6] = -world_pti[0] * vertex_1[i];
            a_pt1[7] = -world_pti[1] * vertex_1[i];
            b_array[i * 2 + 0][0] = vertex_0[i];
            b_array[i * 2 + 1][0] = vertex_1[i];
        }
        if (!a.matrixSelfInv()) {
            return false;
        }
        o_para.matrixMul(a, b);
        return true;
    }

    private static void initValue_wk_pickFromRaster_ext_pat2(int[][][] i_ext_pat2, int i_width, int i_height) {
        for (int i = i_height - 1; i >= 0; --i) {
            int[][] pt2 = i_ext_pat2[i];
            for (int i2 = i_width - 1; i2 >= 0; --i2) {
                int[] pt1 = pt2[i2];
                pt1[0] = 0;
                pt1[1] = 0;
                pt1[2] = 0;
            }
        }
    }

    @Override
    public boolean pickFromRaster(NyARRaster image, NyARMarker i_marker) throws NyARException {
        int[] ext_pat2_j_i;
        int i;
        int[][] ext_pat2_j;
        int j;
        NyARMat cpara = this.wk_pickFromRaster_cpara;
        int[] x_coord = i_marker.x_coord;
        int[] y_coord = i_marker.y_coord;
        int[] vertex = i_marker.mkvertex;
        double[] local_0 = this.wk_pickFromRaster_local[0];
        double[] local_1 = this.wk_pickFromRaster_local[1];
        for (int i2 = 0; i2 < 4; ++i2) {
            local_0[i2] = x_coord[vertex[i2]];
            local_1[i2] = y_coord[vertex[i2]];
        }
        double w1 = local_0[0] - local_0[1];
        double w2 = local_1[0] - local_1[1];
        w1 = local_0[2] - local_0[3];
        w2 = local_1[2] - local_1[3];
        int l2 = (int)(w1 * w1 + w2 * w2);
        int l1 = (int)(w1 * w1 + w2 * w2);
        if (l2 > l1) {
            l1 = l2;
        }
        l1 /= 4;
        int xdiv2 = this.width;
        while (xdiv2 * xdiv2 < l1) {
            xdiv2 *= 2;
        }
        if (xdiv2 > 64) {
            xdiv2 = 64;
        }
        w1 = local_0[1] - local_0[2];
        w2 = local_1[1] - local_1[2];
        w1 = local_0[3] - local_0[0];
        w2 = local_1[3] - local_1[0];
        l2 = (int)(w1 * w1 + w2 * w2);
        l1 = (int)(w1 * w1 + w2 * w2);
        if (l2 > l1) {
            l1 = l2;
        }
        int ydiv2 = this.height;
        l1 /= 4;
        while (ydiv2 * ydiv2 < l1) {
            ydiv2 *= 2;
        }
        if (ydiv2 > 64) {
            ydiv2 = 64;
        }
        if (!this.get_cpara(local_0, local_1, cpara)) {
            return false;
        }
        int img_x = image.getWidth();
        int img_y = image.getHeight();
        int[][][] ext_pat2 = this.wk_pickFromRaster_ext_pat2;
        NyARColorPatt_O2.initValue_wk_pickFromRaster_ext_pat2(ext_pat2, this.width, this.height);
        double[][] cpara_array = cpara.getArray();
        double para00 = cpara_array[0][0];
        double para01 = cpara_array[1][0];
        double para02 = cpara_array[2][0];
        double para10 = cpara_array[3][0];
        double para11 = cpara_array[4][0];
        double para12 = cpara_array[5][0];
        double para20 = cpara_array[6][0];
        double para21 = cpara_array[7][0];
        int[] rgb_tmp = this.wk_pickFromRaster_rgb_tmp;
        int xdiv = xdiv2 / this.width;
        int ydiv = ydiv2 / this.height;
        double xdiv2_reciprocal = 1.0 / (double)xdiv2;
        double ydiv2_reciprocal = 1.0 / (double)ydiv2;
        for (j = 0; j < ydiv2; ++j) {
            double yw = 102.5 + 5.0 * ((double)j + 0.5) * ydiv2_reciprocal;
            double para21_x_yw = para21 * yw + 1.0;
            double para11_x_yw = para11 * yw + para12;
            double para01_x_yw = para01 * yw + para02;
            ext_pat2_j = ext_pat2[j / ydiv];
            for (i = 0; i < xdiv2; ++i) {
                double xw = 102.5 + 5.0 * ((double)i + 0.5) * xdiv2_reciprocal;
                double d = para20 * xw + para21_x_yw;
                if (d == 0.0) {
                    throw new NyARException();
                }
                int xc = (int)((para00 * xw + para01_x_yw) / d);
                int yc = (int)((para10 * xw + para11_x_yw) / d);
                if (xc < 0 || xc >= img_x || yc < 0 || yc >= img_y) continue;
                image.getPixel(xc, yc, rgb_tmp);
                ext_pat2_j_i = ext_pat2_j[i / xdiv];
                ext_pat2_j_i[0] = ext_pat2_j_i[0] + rgb_tmp[0];
                ext_pat2_j_i[1] = ext_pat2_j_i[1] + rgb_tmp[1];
                ext_pat2_j_i[2] = ext_pat2_j_i[2] + rgb_tmp[2];
            }
        }
        int xdiv_x_ydiv = xdiv * ydiv;
        for (j = this.height - 1; j >= 0; --j) {
            int[][] extpat_j = this.extpat[j];
            ext_pat2_j = ext_pat2[j];
            for (i = this.width - 1; i >= 0; --i) {
                ext_pat2_j_i = ext_pat2_j[i];
                int[] extpat_j_i = extpat_j[i];
                extpat_j_i[0] = ext_pat2_j_i[0] / xdiv_x_ydiv;
                extpat_j_i[1] = ext_pat2_j_i[1] / xdiv_x_ydiv;
                extpat_j_i[2] = ext_pat2_j_i[2] / xdiv_x_ydiv;
            }
        }
        return true;
    }
}

