/* vframe_mgr.h */

#ifndef _VFRAME_MGR_H
#define _VFRAME_MGR_H

#include "inttypes.h"
#include "util.h"
#include <pthread.h>

typedef struct VFRAME_tag {
  struct VFRAME_tag *prev;
  struct VFRAME_tag *next;
#define NORMAL_VFRAME (1<<0)
#define EXT_VFRAME    (1<<1)
#define START_VFRAME  (1<<2)
#define END_VFRAME    (1<<3)
#define QUIT_VFRAME   (1<<4)
#define DROP_VFRAME   (1<<5)
#define INTRA_VFRAME  (1<<6)
#define INTER_VFRAME  (1<<7)
  uint32_t flag;
  u_time time;
  int32_t csp;
  int32_t data_length;
  int32_t data_buf_size;
  uint8_t *data;
  uint8_t *bufp;
} VFRAME;

typedef struct {
  pthread_mutex_t mutex;
#define SRC_WAIT       (1<<0)
#define ENC_WAIT       (1<<1)
#define DST_WAIT       (1<<2)
#define FREE_WAIT      (1<<3)
#define ENC_SRC_WAIT   (1<<4)
#define ENC_DST_WAIT   (1<<5)
  int vframe_flag;
  int width;
  int height;
  int max_pixel_depth;
  int data_buf_size;
  unsigned int last_frame_alloc_count;
  unsigned int max_last_frame_alloc_count;
//  int max_last_ext_frame_alloc_count;
  int max_frame_num;
  int max_ext_frame_num;

  int alloc_frame_num;
  int alloc_ext_frame_num;
  int free_frame_num;
  int used_frame_num;
  int src_frame_num;
  int dst_frame_num;

  void (*enc_wait_cb) (void);
  void (*src_wait_cb) (void);
  void (*dst_wait_cb) (void);

  VFRAME *free_chain;
  VFRAME *src_chain;
  VFRAME *dst_chain;

  VFRAME *src_frame;
  VFRAME *dst_frame;
  VFRAME *enc_src_frame;
  VFRAME *enc_dst_frame;
} VFRAME_MGR;

#define VFRAME_MGR_OK         0
#define VFRAME_MGR_FAIL      -1
#define VFRAME_MGR_NOT_READY -2
#define VFRAME_MGR_BUSY  -3

int  vframe_get_width(void);
int  vframe_get_height(void);
int  vframe_get_pixel_depth(void);
int  vframe_get_buf_size(void);
VFRAME* vframe_ext_frame_get(void);
VFRAME* vframe_src_frame_get(void);
void vframe_src_frame_update(VFRAME *vfrm);
//int  vframe_enc_frame_get(VFRAME **src_vfrm, VFRAME **dst_vfrm);
//void vframe_enc_frame_update(VFRAME **src_vfrm, VFRAME **dst_vfrm);
VFRAME* vframe_enc_src_frame_get(void);
void vframe_enc_src_frame_update(VFRAME *vfrm);
VFRAME* vframe_enc_dst_frame_get(void);
void vframe_enc_dst_frame_update(VFRAME *vfrm);
VFRAME* vframe_dst_frame_get(void);
void vframe_dst_frame_update(VFRAME *vfrm);

void vframe_set_src_wait_cb(void (*wait_cb)(void));
void vframe_set_enc_wait_cb(void (*wait_cb)(void));
void vframe_set_dst_wait_cb(void (*wait_cb)(void));

int vframe_mgr_init(int width, int height, int max_pixel_depth, int max_buf);
int vframe_mgr_quit(void);
int vframe_mgr_error_quit(void);

#endif /* _VFRAME_MGR_H */

