/* venc.h */

#ifndef _VENC_H
#define _VENC_H

typedef struct {
  pthread_t venc_th;
  pthread_mutex_t mutex;
  pthread_cond_t interface_wait_cond;
  pthread_cond_t thread_wait_cond;
  int wait_cb_called;
  int state;
  unsigned long fourcc;
  int    width;
  int    height;
  double fps;
  int    in_csp;
} VENC_CONFIG;

#define VENC_OK    0
#define VENC_FAIL -1

int venc_get_max_buffers(void);

int venc_state_error(void);
int venc_state_start(void);
int venc_state_pause(void);
int venc_state_toggle_pause(void);
int venc_state_stop(void);
int venc_state_quit(void);

void venc_enc_wait_cb(void);

int venc_init (int width, int height, double fps, unsigned long fourcc, int in_csp);
int venc_quit (void);
int venc_error_quit (void);

#endif /* _VENC_H */

