/* vcodec.h */

#ifndef _VCODEC_H
#define _VCODEC_H

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <inttypes.h>

#define CODEC_FOURCC(c1,c2,c3,c4) ((unsigned long)\
 (((c1)&0xFF)|(((c2)&0xFF)<<8)|(((c3)&0xFF)<<16)|(((c4)&0xFF)<<24)))

#define VCODEC_UNKNOWN    CODEC_FOURCC(0,0,0,0)
#define VCODEC_XVID       CODEC_FOURCC('X','V','I','D')
#define VCODEC_RGB24      CODEC_FOURCC('R','G','B',24)
#define VCODEC_YV12       CODEC_FOURCC('Y','V','1','2')
#define VCODEC_RTJPEG     CODEC_FOURCC('R','T','J','0')

#ifdef HAVE_LIBAVCODEC
#define VCODEC_MPEG1      CODEC_FOURCC('m','p','g','1')
#define VCODEC_H263       CODEC_FOURCC('H','2','6','3')
#define VCODEC_H263P      CODEC_FOURCC('H','2','6','P')
#define VCODEC_RV10       CODEC_FOURCC('R','V','1','0')
#define VCODEC_MJPEG      CODEC_FOURCC('M','J','P','G')
#define VCODEC_MPEG4      CODEC_FOURCC('M','P','G','4')
#define VCODEC_MSMPEG4V3  CODEC_FOURCC('M','P','4','3')
#define VCODEC_MSMPEG4V2  CODEC_FOURCC('M','P','4','2')
#define VCODEC_MSMPEG4V1  CODEC_FOURCC('M','P','G','1')
#define VCODEC_WMV1       CODEC_FOURCC('W','M','V','1')
#define VCODEC_WMV2       CODEC_FOURCC('W','M','V','2')
#define VCODEC_HUFFYUV    CODEC_FOURCC('h','f','y','u')
#endif /* HAVE_LIBAVCODEC */


#define VCODEC_CAP_NONE      0
#define VCODEC_CAP_ENCODE    (1L<<0)
#define VCODEC_CAP_DECODE    (1L<<1)


typedef struct VCODEC_tag VCODEC;

typedef struct {
  int (*encode_init) (VCODEC *vcodec);
  int (*encode_quit) (void);
  int (*encode_csp_cap) (int csp);
  int (*encode) (unsigned char *pic_data, unsigned char *stream_buf,
                 int stream_buf_size, unsigned int *flag);
  void (*encode_print_param) (void);

  int (*decode_init) (VCODEC *vcodec);
  int (*decode_quit) (void);
  int (*decode_csp_cap) (int csp);
  int (*decode) (unsigned char *pic_data, unsigned char *stream,
                 int stream_length, unsigned int *flag);
  void (*decode_print_param) (void);

  const char* (*codec_to_fourcc_str) (uint32_t codec);
  uint32_t (*fourcc_str_to_codec) (const char *fourcc_str);
  uint32_t (*codec_cap) (uint32_t codec, uint32_t cap_flag);
} VCODEC_FUNCS;

struct VCODEC_tag {
  uint32_t codec;
  int width;
  int height;
  double fps;
  int in_csp;
  int out_csp;
  int codec_idx;

  VCODEC_FUNCS *funcs;
};

#define VCODEC_FAIL -1
#define VCODEC_OK    0

#define VCODEC_IS_INTRA    (1L<<1)
#define VCODEC_IS_INTER    (1L<<2)
#define VCODEC_FORCE_INTRA (1L<<3)
#define VCODEC_FORCE_INTER (1L<<4)
#define VCODEC_NULL_DECODE (1L<<5)


int vcodec_encode_set_codec(uint32_t fourcc);
int vcodec_encode_csp_cap(int in_csp);
int vcodec_encode_get_out_csp(void);
int vcodec_encode_init(unsigned long codec, int width, int height,
                       double fps, int in_csp);
int vcodec_encode_reset(void);
extern int (*vcodec_encode)(unsigned char* pic_data, unsigned char *stream_buf,
                  int stream_buf_size, unsigned int *flag);
int vcodec_encode_quit(void);
void vcodec_encode_print_param(void);


int vcodec_decode_set_codec(uint32_t fourcc);
int vcodec_decode_csp_cap(int out_csp);
int vcodec_decode_get_out_csp(void);
int vcodec_decode_init(unsigned long codec, int width, int height, int out_csp);
int vcodec_decode_reset(void);
extern int (*vcodec_decode)(unsigned char* pic_data, unsigned char *stream,
                  int stream_length, unsigned int *flag);
int vcodec_decode_quit(void);
void vcodec_decode_print_param(void);

const char *vcodec_get_codec_name(uint32_t codec);
unsigned long vcodec_str_to_codec(const char *str);

const char *vcodec_codec_to_fourcc_str(uint32_t codec);
uint32_t vcodec_fourcc_str_to_codec(const char *fourcc_str);
uint32_t vcodec_codec_cap(uint32_t codec, uint32_t cap_flag);

#endif /* _VCODEC_H */

