/* vc_xvid.h */

#ifndef _VC_XVID_H
#define _VC_XVID_H

#include <stdio.h>
#include "xvid_vbr.h"

typedef struct {
#define VC_XVID_MODE_CBR       0
#define VC_XVID_MODE_VBR_QUANT 1
#define VC_XVID_MODE_2PASS_1   2
#define VC_XVID_MODE_2PASS_2   3
  int mode;
  int quality;
#define VC_XVID_QUANT_TYPE_DEFAULT 0
#define VC_XVID_QUANT_TYPE_H263    1
#define VC_XVID_QUANT_TYPE_MPEG    2
#define VC_XVID_QUANT_TYPE_MOD     3
#define VC_XVID_QUANT_TYPE_CUSTOM  4
  int quant_type;
  int bitrate;
  int quant;


  int interlacing;
  int adaptivequant;
  int halfpel;
  int inter4v;
//  int greyscale;

  int hintedme;
  char *hintfile;

  int rc_reaction_delay_factor;
  int rc_averaging_period;
  int rc_buffer;

  int intra_only;
//  int me_method;

  unsigned char *quant_intra_matrix;
  unsigned char *quant_inter_matrix;

//  int debug;
  char *passfile;
//  int desired_bitrate;
//  int desired_size;
  int keyframe_boost;
  int kftreshold;
  int kfreduction;
  int min_key_interval;
  int max_key_interval;
  int curve_compression_high;
  int curve_compression_low;
  int use_alt_curve;
  int alt_curve_type;
  int alt_curve_low_dist;
  int alt_curve_high_dist;
  int alt_curve_min_rel_qual;
  int alt_curve_use_auto;
  int alt_curve_auto_str;
  int alt_curve_use_auto_bonus_bias;
  int alt_curve_bonus_bias;
  int bitrate_payback_method;
  int bitrate_payback_delay;
  int max_iquant;
  int min_iquant;
  int max_pquant;
  int min_pquant;
  int twopass_max_bitrate;
  int twopass_max_overflow_improvement;
  int twopass_max_overflow_degradation;

} VC_XVID_PARAM;

typedef struct {
  const char *hint_fname;
  FILE *hint_fp;
  void *hint_buf;

  int mode;
  int gen_flag;
  int mot_flag;
  int xcsp;
  int mod_quant;
  int intra_only;

  unsigned char *quant_intra_matrix;
  unsigned char *quant_inter_matrix;
} VC_XVID_VBR_CONF;

typedef struct {
  int width;
  int height;
  double fps;
  int in_csp;
  int out_csp;

  int xcsp;
  void *handle;
} VC_XVID_CONF;

int vc_xvid_init (void);

extern VCODEC_FUNCS vc_xvid_funcs;

#endif /* _VC_XVID_H */

