/* vc_libavcodec.h */

#ifndef _VC_LIBAVCODEC_H
#define _VC_LIBAVCODEC_H

#include "avcodec.h"

typedef struct {
  int bitrate;
  int gop_size;
  int intra_only;
  int do_pass;
  char *passlogfile;
  int qscale;
  int qmin;
  int qmax;
  int mb_qmin;
  int mb_qmax;
  int qdiff;
  float qblur;
  float qcomp;
  float rc_init_cplx;
  float b_qfactor;
  float i_qfactor;
  float b_qoffset;
  float i_qoffset;
  char *rc_eq;
//  char *rc_override_string;
  int bitrate_tolerance;    // kilo
  int rc_max_rate;    // kilo
  int rc_min_rate;    // kilo
  int rc_buffer_size; // kilo
#define VLAVC_ME_DEF      0
#define VLAVC_ME_ZERO     1
#define VLAVC_ME_FULL     2
#define VLAVC_ME_LOG      3
#define VLAVC_ME_PHODS    4
#define VLAVC_ME_EPZS     5
#define VLAVC_ME_X1       6
  int me_method;
  int dct_algo;
  int idct_algo;
  int error_resilience;
  int error_concealment;
  int b_frames;
  int use_hq;
  int use_4mv;
  int use_part;
  int workaround_bugs;
  int strict;
//  int same_quality;
  int debug;
  int packet_size;

//  float rc_buffer_aggressivity;

//  int do_psnr;

} VC_LIBAVCODEC_PARAM;

typedef struct {
  uint32_t codec;
  int width;
  int height;
  double fps;
  int in_csp;
  int out_csp;
  int data_size;
  int pix_fmt;
  int v_offset;
  int u_offset;
  int uv_width;
  int quality;
  FILE *logfile;
  enum CodecID codec_id;
  AVCodecContext *context;
  AVCodec *avcodec;
  AVFrame *picture;
} VC_LIBAVCODEC_CONF;

int vc_libavcodec_init (void);

extern VCODEC_FUNCS vc_libavcodec_funcs;

#endif /* _VC_LIBAVCODEC_H */

