/* v4l.h */

#ifndef _V4L_H
#define _V4L_H

#include <sys/types.h>
#include <linux/types.h>
#include <linux/videodev.h>
#include <inttypes.h>

#define V4L_OK    0
#define V4L_FAIL -1

typedef struct {
  const char *device_name;
  int fd;

  int name[32];
  int type;
  int channels;
  int audios;
  int maxwidth;
  int maxheight;
  int minwidth;
  int minheight;

  int source_channel;
  char channel_name[32];
  int channel_tuners;
  uint32_t channel_flags;
  int channel_type;
  int channel_norm;

  int tuner;
  char tuner_name[32];
  uint32_t rangelow;
  uint32_t rangehigh;
  uint32_t tuner_flags;
  int tuner_mode;
  int tuner_signal;

  uint32_t freq;
  int norm;

  int brightness;
  int hue;
  int colour;
  int contrast;
  int whiteness;
  int depth;
  int palette;

  int audio;
  int audio_volume;
  int audio_bass;
  int audio_treble;
  uint32_t audio_flags;
  char audio_name[16];
  int audio_mode;
  int audio_balance;
  int audio_step;

  int x;
  int y;
  int width;
  int height;
  int chromakey;
  uint32_t win_flags;

  int frames;
  int cur_frame;
  int *offsets;
  int map_size;
  char *map_data;

  struct video_mmap vid_mmap;

} V4L_PARAM;

int v4l_init (const char *device_name, int source_channel, int tuner, int norm, int audio);
int v4l_quit (void);
int v4l_open (const char *device_name);
int v4l_close (void);
int v4l_capture_cap(void);

int   v4l_grab_pic_start (void);
char *v4l_grab_pic_sync (void);
int   v4l_grab_pic_capture (void);
int   v4l_grab_pic_stop (void);

int  v4l_overlay_on (void);
int  v4l_overlay_off (void);

int  v4l_set_source_channel (int source_channel);
int  v4l_get_channel (void);
int  v4l_set_tuner (int tuner);
int  v4l_get_tuner (void);
int  v4l_set_freq (int freq);
int  v4l_get_freq (void);
int  v4l_set_audio (int audio, int on);
int  v4l_set_window_size (int width, int height);
int  v4l_get_window_size (int *width, int *height);

int v4l_set_csp (int csp);
int v4l_get_csp (void);

int v4l_color(int brightness, int hue, int colour, int contrast, int whiteness);
#define V4L_BRIGHTNESS 0
#define V4L_HUE        1
#define V4L_COLOUR     2
#define V4L_CONTRAST   3
#define V4L_WHITENESS  4
int   v4l_set_color (float percent, int element);
int   v4l_set_brightness(float percent);
int   v4l_set_hue(float percent);
int   v4l_set_colour(float percent);
int   v4l_set_contrast(float percent);
int   v4l_set_whiteness(float percent);
float v4l_get_color (int element);
float v4l_get_brightness(void);
float v4l_get_hue(void);
float v4l_get_colour(void);
float v4l_get_contrast(void);
float v4l_get_whiteness(void);

#define NORM_UNKNOWN  -1
#define NORM_PAL       0
#define NORM_NTSC      1
#define NORM_SECAM     2
#define NORM_AUTO      3
int  v4l_set_norm (int norm);
int  v4l_get_norm (void);

void v4l_print_param(void);

#endif /* _V4L_H */

