/* parseopt.h */

#ifndef _PARSEOPT_H
#define _PARSEOPT_H

#define NO_ERROR   0
#define HAVE_ERROR 1

#define MAX_STRING_LENGTH 1024
#define MAX_LINE_LENGTH 40

typedef struct {
  const char *name;
  int id;
} SEL_COMPO;

typedef struct {
    const char *name;
    const char *alt_name;
#define HAS_ARG    0x0001
#define OPT_BOOL   0x0002
#define OPT_INT    0x0004
#define OPT_STR    0x0008
#define OPT_FUNC   0x0010
#define OPT_SEL    0x0020
#define OPT_KILO   0x0040
#define OPT_BEFORE 0x0080
    int flags;
    union {
        int (*func_arg)();
        int *int_arg;
        char **str_arg;
    } v;
    union {
      int val;
      char *str;
    } def;
    union {
      int min_val;
      SEL_COMPO *sel;
    } min_sel;
    int max_val;
    const char *help;
    const char *argname;
} OptionDef;

/* { name, rc_name, flags, dest|func, default, min|select, max, help, argname }
 * */

typedef struct {
  OptionDef *opts;
  int *opts_num;
  const char *name;
} OptionDefs;

typedef int (*PARSEOPT_DEFAULT_FUNC)(const char*);

void parseopt_print_cmd_opt (void);

void parseopt_set_option_defs (OptionDefs *ops);
void parseopt_set_default_func (int (*func)(const char*));
OptionDef *parseopt_get_optiondef(const char *name);
OptionDef *parseopt_get_optiondef_alt(const char *alt_name);
int parseopt_get_default(const char *cmd_name, int *flags_ret);
int parseopt_get_default_alt(const char *alt_name, int *flags_ret);
void parseopt_quit(void);
int  parseopt_cmd (int argc, char *argv[]);
int  parseopt_set_value(OptionDef *po, const char *arg);
int  parseopt_defaults(const char *fname);
int  parseopt_change_default(OptionDef *po, const char *arg);
int  parse_line(char *line, char *subj, char *pred);
int parseopt_set_default (const char* name, int *flags_ret);
int  parseopt_set_command(const char *com, const char *arg);

#endif /* _PARSEOPT_H */

