/* oss.h */

#ifndef _OSS_H
#define _OSS_H

#define OSS_OK    0
#define OSS_FAIL -1

typedef struct {
  const char *dev_name;
  int fd;
  int rate;
  int channels;
  int bytespspl;
  int bitspspl;
  int format;
  int fragments;
  int fragsize;
  int fragstotal;

  const char *mix_dev_name;
  int mix_fd;
  int device_mask;
  int reccap_mask;
  int stereo_mask;
  int recsrc_mask;
  int excl_input;
} OSS_PARAM;

int  oss_get_rate (void);
int  oss_get_channels (void);
int  oss_get_bitspspl (void);
int  oss_get_bytespspl (void);
int  oss_get_fragments (void);
int  oss_get_fragsize (void);
int  oss_get_fragstotal (void);
int  oss_get_format (void);
int  oss_read_data (char* buf, int buf_size);
int  oss_init (const char *device_name, int rate, int channel, int bitpspl);
int  oss_quit (void);

//int  oss_write (char *buf, int byte_length);
//int  oss_post (void);
//int  oss_sync (void);

int  oss_mixer_name_to_id(const char *name);
const char *oss_mixer_id_to_name(int id);
int  oss_mixer_dev_id(const char *name);
int  oss_mixer_stereo_cap(int id);
int  oss_mixer_record_cap(int id);
int  oss_mixer_record_enable(int id);
int  oss_mixer_record_disable(int id);
int  oss_mixer_vol_set(int id, int left, int right);
int  oss_mixer_vol_get(int id, int *left, int *right);
int  oss_mixer_close(void);
int  oss_mixer_open(const char *device_name);
void oss_print_param(void);

#endif /* _OSS_H */

