/*
 * zoom.h (C) nejik 2003
 */

/*
 * References: Paul Heckber's zoom program
 * http://www.cs.cmu.edu/~ph
 *
 * Copyright:
 * Copyright (c) 1989  Paul S. Heckbert
 * This source may be used for peaceful, nonprofit purposes only, unless
 * under licence from the author. This notice should remain in the source.
 *
 */


#ifndef _ZOOM_HDR
#define _ZOOM_HDR

#define PI 3.14159265358979323846264338
#define WEIGHTBITS  14                  /* # bits in filter coefficients */
#define WEIGHTONE  (1<<WEIGHTBITS)      /* filter weight of one */
#define EPSILON 1e-7                    /* error tolerance */
#define CHANBITS 8
#define FINALSHIFT  (2*WEIGHTBITS-CHANBITS) /* shift after x&y filter passes */

typedef struct {
  int start_pos;
  int end_pos;
  int window_length;
  short *weights;
} Weighttab;

typedef struct {
  int csp;
  int xy;
  int src_image_width, src_image_height;
  int dest_image_width, dest_image_height;
  int src_width, src_height;
  int dest_width, dest_height;
  int src_stride, dest_stride;
  int src_left, src_right, src_top, src_bottom;
  int start_x, end_x;
  int start_y, end_y;
  int start_x_uv, end_x_uv;
  int start_y_uv, end_y_uv;
  double x_scale, y_scale;
  double x_blur, y_blur;
  double x_supp, y_supp;
  const char *x_filt_name;
  const char *x_window_name;
  const char *y_filt_name;
  const char *y_window_name;
  int x_window_length;
  int y_window_length;
  Weighttab *x_wtab;
  Weighttab *y_wtab;
  int x2_window_length;
  int y2_window_length;
  Weighttab *x2_wtab;
  Weighttab *y2_wtab;
} ZOOM_PARAM;

const char* zoom_set_xfilt(const char *filt_name);
const char* zoom_set_xwindow(const char *window_name);
void zoom_set_xsupp(double supp);
void zoom_set_xblur(double blur);
const char* zoom_set_yfilt(const char *filt_name);
const char* zoom_set_ywindow(const char *window_name);
void zoom_set_ysupp(double supp);
void zoom_set_yblur(double blur);
void zoom(unsigned char *dest, unsigned char *src);
int zoom_init(int src_image_width, int src_image_height, int src_x1, int src_y1, int src_x2, int src_y2, int dest_image_width, int dest_image_height, int dest_x1, int dest_y1, int dest_x2, int dest_y2, int csp);

#endif /* _ZOOM_HDR */

