/*
 * FILE: resample.h
 *
 */


#ifndef RESAMPLE_H
#define RESAMPLE_H

int resample(                   /* number of output samples returned */
    short *isample[],           /* input samples buffer */
    int   isample_num,          /* number of input samples*/
    short *osample[],           /* output samples buffer */
    int   osample_buf_size      /* size of samples which can permit a buffer */
);

int resample_drain(             /* number of output samples returned */
    short *osample[],           /* output samples buffer */
    int   osample_buf_size      /* size of samples which can permit a buffer */
);

int resample_init(              /* if ERROR occured, !0 returned. otherwise 0 */
    int    in_rate,             /* input and output sample rate */
    int    out_rate,
    int    nChans,              /* number of sound channels (1 or 2) */
    int    interpFilt,          /* TRUE means interpolate filter coeffs */
    int    largeFilter          /* TRUE means use 65-tap FIR filter */
);

void resample_quit(void);

int resample_get_input_sample_size(void); /* input buffer sample size returned */
int resample_get_output_sample_size(void); /* output buffer sample size returned */

#endif /* RESAMPLE_H */

