/* ofile.h */

#ifndef __OFILE_HDR
#define __OFILE_HDR

#include <avilib.h>
#include <qtime.h>
#include "parseopt.h"

#define OUTPUT_FILE  0
#define OUTPUT_XWIN  1

typedef struct {
  char *name;
  int file_format;
  avi_t *avifile;
  qtime_t *qt;
  qtime_track_t *vqtrk;
  qtime_track_t *aqtrk;
  long frames;
  int vcodec;
  int width;
  int height;
  double fps;
  const char *compressor;

  int acodec;
  int channels;
  int bits;
  int format;
  int rate;
  long audio_bytes;
  int bitrate;
  int bytespspl;
  int frame_size;
  int audio_be;

  int audio_disable;
  int resize_flag;
  int deinterlace_flag;
  int interp_type;
} OUT_FILE;

#define MAX_FILENAME_LENGTH 4096

int init_iofile(void);
void quit_iofile(void);
int init_ofile(void);
void quit_ofile(void);
int ofile_set_video(OUT_FILE *ofile);
int ofile_set_audio(OUT_FILE *ofile);
OUT_FILE* get_video_out_file(void);
OUT_FILE* get_audio_out_file(void);
int write_video_frame(OUT_FILE* o_file, unsigned char *data_buf, int data_size,
    int keyframe);
int write_audio_data(OUT_FILE* o_file, unsigned char *stream_buf,int data_size, int num_samples);

extern OptionDef out_file_param[];
extern int out_file_param_num;

#endif /* __OFILE_HDR */

