/* video_desc.h */

#ifndef VIDEO_DESC_H
#define VIDEO_DESC_H

#include "atom.h"
#include "sample_desc.h"
#include "ctab.h"

#define QTIME_TYPE_VDSC    QTIME_TYPE('V','D','S','C')

#define QTIME_TYPE_GAMA           QTIME_TYPE('g','a','m','a')
#define QTIME_TYPE_FIEL           QTIME_TYPE('f','i','e','l')
#define QTIME_TYPE_MJQT           QTIME_TYPE('m','j','q','t')
#define QTIME_TYPE_MJHT           QTIME_TYPE('m','j','h','t')

typedef struct {
  int16_t  version;
  int16_t  revision_level;
  int32_t  vendor;
  int32_t  temporal_quality;
  int32_t  spatial_quality;
  int16_t  width;
  int16_t  height;
  uint32_t horizontal_resolution;   // fixed32
  uint32_t vertical_resolution;     // fixed32
  int32_t  data_size;               // set to 0
  int16_t  frame_count;             // usually 1
  uint8_t  compressor_name[32];         // pascal string
  int16_t  depth;
  int16_t  color_table_id;
} VIDEO_DESC_PROP;

#define VIDEO_DESC_PROP_SIZE (70)

typedef struct {
  sample_desc_t sample_desc;
  int16_t  version;
  int16_t  revision_level;
  int32_t  vendor;
  int32_t  temporal_quality;
  int32_t  spatial_quality;
  int16_t  width;
  int16_t  height;
  uint32_t horizontal_resolution;   // fixed32
  uint32_t vertical_resolution;     // fixed32
  int32_t  data_size;               // set to 0
  int16_t  frame_count;             // usually 1
  uint8_t  compressor_name[32];         // pascal string
  int16_t  depth;
  int16_t  color_table_id;

  ctab_t *ctab;

#define VIDEO_DESC_EXT_NONE     (0)
#define VIDEO_DESC_EXT_GAMA     (1L<<0)
#define VIDEO_DESC_EXT_FIEL     (1L<<1)
#define VIDEO_DESC_EXT_MJQT     (1L<<2)
#define VIDEO_DESC_EXT_MJHT     (1L<<3)
  uint32_t ext_flag;
  int32_t  gama;
  uint8_t  fiel[2];
  uint8_t  *mjqt;
  uint8_t  *mjht;
} video_desc_t;


video_desc_t* video_desc_read_atom(qtime_io_t *qtio, atom_head_t *atom_head, video_desc_t *video_desc);
video_desc_t* video_desc_create(video_desc_t *video_desc);
int         video_desc_write_atom(qtime_io_t *qtio, video_desc_t *video_desc);
void        video_desc_dump(const char *parent_types, video_desc_t *video_desc);


void          video_desc_init(video_desc_t *video_desc);
video_desc_t* video_desc_new(void);
void          video_desc_clean(video_desc_t *video_desc);
void          video_desc_delete(video_desc_t *video_desc);
int64_t       video_desc_calc_size(video_desc_t *video_desc);


#endif /* VIDEO_DESC_H */

